/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.properties;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class ClassPropertyKey {
    private final Object id;
    private final Class<?> declaringClass;

    public ClassPropertyKey(String name) {
        this(name, null);
    }

    public ClassPropertyKey(String name, Class<?> declaringClass) {
        this((Object)name, declaringClass);
    }

    public ClassPropertyKey(Object id, Class<?> declaringClass) {
        this.id = ClassPropertyKey.assertId(id);
        this.declaringClass = ClassPropertyKey.assertDeclaringClass(declaringClass);
    }

    private static Object assertId(Object id) {
        Preconditions.checkArgument((id != null && !id.toString().trim().isEmpty() ? 1 : 0) != 0, (Object)"Property id cannot be null or empty!");
        return id;
    }

    private static Class<?> assertDeclaringClass(Class<?> declaringClass) {
        if (declaringClass != null) {
            Preconditions.checkArgument((!declaringClass.isPrimitive() ? 1 : 0) != 0, (Object)"Primitive types cannot have any members!");
        }
        return declaringClass;
    }

    public Object getId() {
        return this.id;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public int hashCode() {
        return Objects.hash(this.getDeclaringClass(), this.getId());
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ClassPropertyKey that = (ClassPropertyKey)object;
            return Objects.equals(this.getDeclaringClass(), that.getDeclaringClass()) && Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public String toString() {
        String classStr = Optional.ofNullable(this.getDeclaringClass()).map(Class::getSimpleName).orElse("?");
        return String.format("%s#%s", classStr, this.getId());
    }
}

