/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.properties;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class ClassPropertyStack {
    private final ClassPropertyStack parent;
    private final ClassPropertyKey value;

    public ClassPropertyStack(ClassPropertyKey value) {
        this(null, value);
    }

    public ClassPropertyStack(ClassPropertyStack parent, ClassPropertyKey value) {
        this.parent = parent;
        this.value = Objects.requireNonNull(value, "Value property key cannot be null!");
    }

    public ClassPropertyStack getParent() {
        return this.parent;
    }

    public ClassPropertyKey getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.toLongCallString()).toString();
    }

    public String toLongCallString() {
        String parentStr = "";
        if (this.getParent() != null) {
            parentStr = this.getParent().toLongCallString() + "->";
        }
        return parentStr + this.getValue().toString();
    }

    public String toCallString() {
        ClassPropertyStack parent = this.getParent();
        if (parent == null) {
            return this.getValue().toString();
        }
        return parent.toCallString() + "." + this.getValue().getId();
    }

    public int hashCode() {
        return Objects.hash(this.getParent(), this.getValue());
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            ClassPropertyStack that = (ClassPropertyStack)object;
            return Objects.equals(this.getParent(), that.getParent()) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    public static ClassPropertyStack createStack(ClassPropertyKey ... keys) {
        ClassPropertyStack parent = null;
        for (ClassPropertyKey key : keys) {
            parent = new ClassPropertyStack(parent, key);
        }
        return parent;
    }
}

