/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.properties;

import com.google.common.base.MoreObjects;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.whaka.util.reflection.Visibility;
import org.whaka.util.reflection.properties.ClassProperty;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class FieldClassProperty<Type, TargetType>
implements ClassProperty<Type, TargetType> {
    private final Field field;
    private final ClassPropertyKey key;
    private final Visibility visibility;

    public FieldClassProperty(Field field) {
        this.field = FieldClassProperty.assertField(field);
        this.key = new ClassPropertyKey(field.getName(), field.getDeclaringClass());
        this.visibility = Visibility.getFromModifiers(field.getModifiers());
    }

    private static Field assertField(Field field) {
        return Objects.requireNonNull(field, "Member field cannot be null!");
    }

    @Override
    public ClassPropertyKey getKey() {
        return this.key;
    }

    @Override
    public Class<Type> getType() {
        return this.field.getType();
    }

    @Override
    public ParameterizedType getGenericType() {
        return (ParameterizedType)this.field.getGenericType();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Type getValue(TargetType target) throws Exception {
        this.field.setAccessible(true);
        return (Type)this.field.get(target);
    }

    @Override
    public void setValue(TargetType target, Type value) throws Exception {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("Cannot change value of a final field");
        }
        this.field.setAccessible(true);
        this.field.set(target, value);
    }

    @Override
    public boolean isMutable() {
        return !Modifier.isFinal(this.field.getModifiers());
    }

    public int hashCode() {
        return Objects.hash(this.getField());
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            FieldClassProperty that = (FieldClassProperty)object;
            return this.getField().equals(that.getField());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("field", (Object)this.getField()).toString();
    }
}

