/*
 * Decompiled with CFR 0.152.
 */
package org.whaka.util.reflection.properties;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import org.whaka.util.reflection.Visibility;
import org.whaka.util.reflection.properties.ClassProperty;
import org.whaka.util.reflection.properties.ClassPropertyKey;

public class GetterClassProperty<Type, TargetType>
implements ClassProperty<Type, TargetType> {
    private final Method getter;
    private final Method setter;
    private final ClassPropertyKey key;
    private final Visibility visibility;

    public GetterClassProperty(Method getter) {
        this(getter, null);
    }

    public GetterClassProperty(Method getter, Method setter) {
        this.getter = GetterClassProperty.assertGetter(getter);
        this.setter = GetterClassProperty.assertSetter(getter, setter);
        this.key = new ClassPropertyKey(getter.getName() + "()", getter.getDeclaringClass());
        this.visibility = Visibility.getFromModifiers(getter.getModifiers());
    }

    private static Method assertGetter(Method getter) {
        Objects.requireNonNull(getter, "Getter method cannot be null!");
        Preconditions.checkArgument((getter.getReturnType() != Void.TYPE ? 1 : 0) != 0, (Object)"Getter cannot have return type 'void'!");
        Preconditions.checkArgument((getter.getParameterCount() == 0 ? 1 : 0) != 0, (Object)"Getter cannot have any arguments!");
        return getter;
    }

    private static Method assertSetter(Method getter, Method setter) {
        if (setter != null) {
            GetterClassProperty.assertConsistentlyStatic(getter, setter);
            GetterClassProperty.assertSetterArguments(setter);
            GetterClassProperty.assertSetterTypeCompatible(getter, setter);
        }
        return setter;
    }

    private static void assertConsistentlyStatic(Method getter, Method setter) {
        boolean setterStatic;
        boolean getterStatic = Modifier.isStatic(getter.getModifiers());
        Preconditions.checkArgument((getterStatic == (setterStatic = Modifier.isStatic(setter.getModifiers())) ? 1 : 0) != 0, (Object)"Getter and setter should be either both static or both NOT static!");
    }

    private static void assertSetterArguments(Method setter) {
        Preconditions.checkArgument((setter.getParameterCount() == 1 ? 1 : 0) != 0, (Object)"Setter method should have exactly one argument");
    }

    private static void assertSetterTypeCompatible(Method getter, Method setter) {
        Preconditions.checkArgument((boolean)GetterClassProperty.isTypeCompatible(getter, setter), (Object)"Setter and getter are not type compatible!");
    }

    public static boolean isTypeCompatible(Method getter, Method setter) {
        Class<?> getterType = getter.getReturnType();
        Class<?> setterType = setter.getParameterTypes()[0];
        return GetterClassProperty.isTypesCompatible(getterType, setterType);
    }

    private static boolean isTypesCompatible(Class<?> getterType, Class<?> setterType) {
        if (setterType.isPrimitive()) {
            return getterType == setterType;
        }
        if (getterType.isPrimitive()) {
            getterType = Primitives.wrap(getterType);
        }
        return setterType.isAssignableFrom(getterType);
    }

    @Override
    public ClassPropertyKey getKey() {
        return this.key;
    }

    @Override
    public Class<Type> getType() {
        return this.getter.getReturnType();
    }

    @Override
    public ParameterizedType getGenericType() {
        return (ParameterizedType)this.getter.getGenericReturnType();
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getter.getModifiers());
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    @Override
    public Type getValue(TargetType target) throws Exception {
        this.getter.setAccessible(true);
        return (Type)this.getter.invoke(target, new Object[0]);
    }

    @Override
    public void setValue(TargetType target, Type value) throws Exception, UnsupportedOperationException, IllegalArgumentException {
        if (!this.isMutable()) {
            throw new UnsupportedOperationException("Cannot set new value! Setter is not present!");
        }
        this.setter.setAccessible(true);
        try {
            this.setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal argument: " + value + "! Expected type: " + this.getType(), e);
        }
    }

    @Override
    public boolean isMutable() {
        return this.setter != null;
    }

    public int hashCode() {
        return Objects.hash(this.getGetter(), this.getSetter());
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            GetterClassProperty that = (GetterClassProperty)object;
            return Objects.equals(this.getGetter(), that.getGetter()) && Objects.equals(this.getSetter(), that.getSetter());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("getter", (Object)this.getGetter()).add("setter", (Object)this.getSetter()).toString();
    }
}

