/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.annotation;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whizu.annotation.ClassFileBuffer;
import org.whizu.annotation.ClassFileIterator;

final class AnnotationDetector {
    private static Logger log = LoggerFactory.getLogger(AnnotationDetector.class);
    private static final boolean DEBUG = false;
    private static final int CP_UTF8 = 1;
    private static final int CP_INTEGER = 3;
    private static final int CP_FLOAT = 4;
    private static final int CP_LONG = 5;
    private static final int CP_DOUBLE = 6;
    private static final int CP_CLASS = 7;
    private static final int CP_STRING = 8;
    private static final int CP_REF_FIELD = 9;
    private static final int CP_REF_METHOD = 10;
    private static final int CP_REF_INTERFACE = 11;
    private static final int CP_NAME_AND_TYPE = 12;
    private static final int BYTE = 66;
    private static final int CHAR = 67;
    private static final int DOUBLE = 68;
    private static final int FLOAT = 70;
    private static final int INT = 73;
    private static final int LONG = 74;
    private static final int SHORT = 83;
    private static final int BOOLEAN = 90;
    private static final int STRING = 115;
    private static final int ENUM = 101;
    private static final int CLASS = 99;
    private static final int ANNOTATION = 64;
    private static final int ARRAY = 91;
    private final ClassFileBuffer cpBuffer = new ClassFileBuffer();
    private final Map<String, Class<? extends Annotation>> annotations;
    private TypeReporter typeReporter;
    private FieldReporter fieldReporter;
    private MethodReporter methodReporter;
    private String typeName;
    private Object[] constantPool;
    private String memberName;

    public AnnotationDetector(Reporter reporter) {
        Class<? extends Annotation>[] a = reporter.annotations();
        this.annotations = new HashMap<String, Class<? extends Annotation>>(a.length);
        for (int i = 0; i < a.length; ++i) {
            this.annotations.put("L" + a[i].getName().replace('.', '/') + ";", a[i]);
        }
        if (reporter instanceof TypeReporter) {
            this.typeReporter = (TypeReporter)reporter;
        }
        if (reporter instanceof FieldReporter) {
            this.fieldReporter = (FieldReporter)reporter;
        }
        if (reporter instanceof MethodReporter) {
            this.methodReporter = (MethodReporter)reporter;
        }
        if (this.typeReporter == null && this.fieldReporter == null && this.methodReporter == null) {
            throw new AssertionError((Object)"No reporter defined");
        }
    }

    public final void detect() throws IOException {
        this.detect(new ClassFileIterator());
    }

    public final void detect(String ... packageNames) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<File> files = new HashSet<File>();
        for (String packageName : packageNames) {
            String internalPackageName = packageName.replace('.', '/');
            if (!internalPackageName.endsWith("/")) {
                internalPackageName = internalPackageName.concat("/");
            }
            Enumeration<URL> resourceEnum = classLoader.getResources(internalPackageName);
            while (resourceEnum.hasMoreElements()) {
                URL url = resourceEnum.nextElement();
                boolean isVfs = "vfs".equals(url.getProtocol());
                if ("file".equals(url.getProtocol()) || isVfs) {
                    File jarFile;
                    String jarPath;
                    int idx;
                    File dir = this.toFile(url);
                    if (dir.isDirectory()) {
                        files.add(dir);
                        continue;
                    }
                    if (!isVfs || (idx = (jarPath = dir.getPath()).indexOf(".jar")) <= -1 || !(jarFile = new File(jarPath = jarPath.substring(0, idx + 4))).isFile()) continue;
                    files.add(jarFile);
                    continue;
                }
                File jarFile = this.toFile(((JarURLConnection)url.openConnection()).getJarFileURL());
                if (jarFile.isFile()) {
                    files.add(jarFile);
                    continue;
                }
                throw new AssertionError((Object)("Not a File: " + jarFile));
            }
        }
        if (!files.isEmpty()) {
            this.detect(files.toArray(new File[files.size()]));
        }
    }

    public final void detect(File ... filesOrDirectories) throws IOException {
        this.detect(new ClassFileIterator(filesOrDirectories));
    }

    private File toFile(URL url) throws UnsupportedEncodingException {
        return new File(URLDecoder.decode(url.getFile(), "UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detect(ClassFileIterator iterator) throws IOException {
        InputStream stream;
        while ((stream = iterator.next()) != null) {
            try {
                this.cpBuffer.readFrom(stream);
                if (!this.hasCafebabe(this.cpBuffer)) continue;
                this.detect(this.cpBuffer);
            }
            catch (Throwable t) {
                if (iterator.isFile()) continue;
                stream.close();
            }
            finally {
                if (!iterator.isFile()) continue;
                stream.close();
            }
        }
    }

    private boolean hasCafebabe(ClassFileBuffer buffer) throws IOException {
        return buffer.size() > 4 && buffer.readInt() == -889275714;
    }

    private void detect(DataInput di) throws IOException {
        this.readVersion(di);
        this.readConstantPoolEntries(di);
        this.readAccessFlags(di);
        this.readThisClass(di);
        this.readSuperClass(di);
        this.readInterfaces(di);
        this.readFields(di);
        this.readMethods(di);
        this.readAttributes(di, 'T', this.typeReporter == null);
    }

    private void readVersion(DataInput di) throws IOException {
        di.skipBytes(4);
    }

    private void readConstantPoolEntries(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        this.constantPool = new Object[count];
        for (int i = 1; i < count; ++i) {
            if (!this.readConstantPoolEntry(di, i)) continue;
            ++i;
        }
    }

    private boolean readConstantPoolEntry(DataInput di, int index) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 1: {
                this.constantPool[index] = di.readUTF();
                return false;
            }
            case 3: {
                di.skipBytes(4);
                return false;
            }
            case 4: {
                di.skipBytes(4);
                return false;
            }
            case 5: {
                di.skipBytes(8);
                return true;
            }
            case 6: {
                di.skipBytes(8);
                return true;
            }
            case 7: 
            case 8: {
                this.constantPool[index] = di.readUnsignedShort();
                return false;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                di.skipBytes(4);
                return false;
            }
        }
        throw new ClassFormatError("Unkown tag value for constant pool entry: " + tag);
    }

    private void readAccessFlags(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readThisClass(DataInput di) throws IOException {
        this.typeName = this.resolveUtf8(di);
    }

    private void readSuperClass(DataInput di) throws IOException {
        di.skipBytes(2);
    }

    private void readInterfaces(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        di.skipBytes(count * 2);
    }

    private void readFields(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            String descriptor = this.resolveUtf8(di);
            this.readAttributes(di, 'F', this.fieldReporter == null);
        }
    }

    private void readMethods(DataInput di) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            this.readAccessFlags(di);
            this.memberName = this.resolveUtf8(di);
            String descriptor = this.resolveUtf8(di);
            this.readAttributes(di, 'M', this.methodReporter == null);
        }
    }

    private void readAttributes(DataInput di, char reporterType, boolean skipReporting) throws IOException {
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            String name = this.resolveUtf8(di);
            int length = di.readInt();
            if (!skipReporting && ("RuntimeVisibleAnnotations".equals(name) || "RuntimeInvisibleAnnotations".equals(name))) {
                this.readAnnotations(di, reporterType);
                continue;
            }
            di.skipBytes(length);
        }
    }

    private void readAnnotations(DataInput di, char reporterType) throws IOException {
        int count = di.readUnsignedShort();
        block5: for (int i = 0; i < count; ++i) {
            String rawTypeName = this.readAnnotation(di);
            Class<? extends Annotation> type = this.annotations.get(rawTypeName);
            if (type == null) continue;
            String externalTypeName = this.typeName.replace('/', '.');
            switch (reporterType) {
                case 'T': {
                    this.typeReporter.reportTypeAnnotation(type, externalTypeName);
                    continue block5;
                }
                case 'F': {
                    this.fieldReporter.reportFieldAnnotation(type, externalTypeName, this.memberName);
                    continue block5;
                }
                case 'M': {
                    this.methodReporter.reportMethodAnnotation(type, externalTypeName, this.memberName);
                    continue block5;
                }
                default: {
                    throw new AssertionError((Object)("reporterType=" + reporterType));
                }
            }
        }
    }

    private String readAnnotation(DataInput di) throws IOException {
        String rawTypeName = this.resolveUtf8(di);
        int count = di.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            di.skipBytes(2);
            this.readAnnotationElementValue(di);
        }
        return rawTypeName;
    }

    private void readAnnotationElementValue(DataInput di) throws IOException {
        int tag = di.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                di.skipBytes(2);
                break;
            }
            case 101: {
                di.skipBytes(4);
                break;
            }
            case 99: {
                di.skipBytes(2);
                break;
            }
            case 64: {
                this.readAnnotation(di);
                break;
            }
            case 91: {
                int count = di.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    this.readAnnotationElementValue(di);
                }
                break;
            }
            default: {
                throw new ClassFormatError("Not a valid annotation element type tag: 0x" + Integer.toHexString(tag));
            }
        }
    }

    private String resolveUtf8(DataInput di) throws IOException {
        int index = di.readUnsignedShort();
        Object value = this.constantPool[index];
        String s = value instanceof Integer ? (String)this.constantPool[(Integer)value] : (String)value;
        return s;
    }

    private static void print(String message, Object ... args) {
    }

    public static interface MethodReporter
    extends Reporter {
        public void reportMethodAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }

    public static interface FieldReporter
    extends Reporter {
        public void reportFieldAnnotation(Class<? extends Annotation> var1, String var2, String var3);
    }

    public static interface TypeReporter
    extends Reporter {
        public void reportTypeAnnotation(Class<? extends Annotation> var1, String var2);
    }

    public static interface Reporter {
        public Class<? extends Annotation>[] annotations();
    }
}

