/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whizu.annotation.AnnotationDetector;
import org.whizu.annotation.TypeReporter;
import org.whizu.util.Chrono;

public class AnnotationUtils {
    private static Logger logger = LoggerFactory.getLogger(AnnotationUtils.class);

    private static void scan(AnnotationDetector.TypeReporter reporter) {
        try {
            new AnnotationDetector(reporter).detect();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Annotation> void scan(final Class<T> clazz, final TypeReporter<T> reporter) {
        if (logger.isDebugEnabled()) {
            logger.debug("Scanning the classpath for @{} annotations", (Object)clazz.getSimpleName());
        }
        Chrono chrono = Chrono.start();
        AnnotationDetector.TypeReporter typeReporter = new AnnotationDetector.TypeReporter(){

            @Override
            public Class<? extends Annotation>[] annotations() {
                return new Class[]{clazz};
            }

            private Class<?> getClass(String className) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public void reportTypeAnnotation(Class<? extends Annotation> annotationClass, String className) {
                Object annotation = this.getClass(className).getAnnotation(clazz);
                reporter.report(annotation, className);
            }
        };
        AnnotationUtils.scan(typeReporter);
        if (logger.isDebugEnabled()) {
            logger.debug("Scanned the classpath for @{} annotations in {}ms", (Object)clazz.getSimpleName(), (Object)chrono.stop());
        }
    }
}

