/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.whizu.dom.Content;
import org.whizu.dom.ContentList;
import org.whizu.dom.Decorator;
import org.whizu.dom.Element;
import org.whizu.dom.Foreach;
import org.whizu.dom.Literal;
import org.whizu.dom.Markup;

public class Node
implements Element {
    private Map<String, String> attrs = new HashMap<String, String>();
    private ContentList contents = new ContentList();
    private List<String> cssList = new ArrayList<String>();
    private String name;
    private Map<String, String> styleMap = new HashMap<String, String>();
    private String id;
    private boolean selfClosing;

    public Node(String name) {
        this(name, false);
    }

    public Node(String name, boolean selfClosing) {
        this.name = name;
        this.selfClosing = selfClosing;
    }

    @Override
    public Element add(Content element) {
        if (this.selfClosing) {
            throw new IllegalStateException("A self-closing element must not add content");
        }
        this.contents.add(element);
        return this;
    }

    @Override
    public Element add(Content ... elements) {
        if (this.selfClosing) {
            throw new IllegalStateException("A self-closing element must not add content");
        }
        for (Content part : elements) {
            this.add(part);
        }
        return this;
    }

    public <E> Element add(Foreach<E> factory) {
        if (this.selfClosing) {
            throw new IllegalStateException("A self-closing element must not add content");
        }
        Iterator<E> it = factory.iterator();
        while (it.hasNext()) {
            E item = it.next();
            this.add(factory.compile(item));
        }
        return this;
    }

    public <E extends Content> Element add(List<E> content) {
        if (this.selfClosing) {
            throw new IllegalStateException("A self-closing element must not add content");
        }
        this.contents.add(content);
        return this;
    }

    @Override
    public Element add(String text) {
        if (this.selfClosing) {
            throw new IllegalStateException("A self-closing element must not add content");
        }
        return this.add((Content)new Literal(text));
    }

    public Element addCss(String clazz) {
        this.cssList.add(clazz);
        return this;
    }

    public Element addStyle(String name, String style) {
        this.styleMap.put(name, style);
        return this;
    }

    @Override
    public Markup after(Content element) {
        return new ContentList(element, this);
    }

    @Override
    public Element attr(String name, String value) {
        if (value != null) {
            this.attrs.put(name, value);
        }
        return this;
    }

    @Override
    public Element border(String style) {
        return this.style("border", style);
    }

    @Override
    public Element css(String className) {
        return className == null ? this : this.addCss(className);
    }

    @Override
    public final Element decorate(Decorator ... decorators) {
        for (Decorator d : decorators) {
            if (d == null) continue;
            d.decorate(this);
        }
        return this;
    }

    private String getCss() {
        String style = "";
        for (String key : this.cssList) {
            style = style + key + " ";
        }
        return style;
    }

    @Override
    public String id() {
        return this.id;
    }

    private String getStyle() {
        String style = "";
        for (String key : this.styleMap.keySet()) {
            style = style + key + ":" + this.styleMap.get(key) + ";";
        }
        return style;
    }

    @Override
    public Element height(String height) {
        return this.style("height", height);
    }

    @Override
    public Element id(String id) {
        this.id = id;
        return this.attr("id", id);
    }

    @Override
    public Element margin(String margin) {
        return this.style("margin", margin);
    }

    @Override
    public Element padding(String style) {
        return this.style("padding", style);
    }

    private String quote(String value) {
        return "'" + value + "'";
    }

    @Override
    public Element size(String size) {
        return this.attr("size", size);
    }

    @Override
    public Element src(String src) {
        return this.attr("src", src);
    }

    @Override
    public Element style(String name, String style) {
        return this.addStyle(name, style);
    }

    @Override
    public Element title(String title) {
        return this.attr("title", title);
    }

    @Override
    public String render() {
        String markup = "<" + this.name;
        for (String key : this.attrs.keySet()) {
            markup = markup + " " + key + "=" + this.quote(this.attrs.get(key));
        }
        if (!this.styleMap.isEmpty()) {
            markup = markup + " style=" + this.quote(this.getStyle());
        }
        if (!this.cssList.isEmpty()) {
            markup = markup + " class=" + this.quote(this.getCss());
        }
        if (this.selfClosing) {
            markup = markup + "/>";
        } else {
            markup = markup + ">";
            markup = markup + this.contents.render();
            markup = markup + "</" + this.name + ">";
        }
        return markup;
    }

    @Override
    public Element width(String width) {
        return width == null ? this : this.style("width", width);
    }

    @Override
    public Element wrap(String name) {
        Node n = new Node(name);
        return n.add((Content)this);
    }

    @Override
    public Element css(List<String> cssList) {
        this.cssList.addAll(cssList);
        return this;
    }

    @Override
    public void style(String style) {
        if (!StringUtils.equals((String)style, (String)"")) {
            String[] styleList;
            for (String element : styleList = style.split(";")) {
                String[] pair = element.split(":");
                this.style(pair[0], pair[1]);
            }
        }
    }
}

