/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.layout;

import org.whizu.dom.Component;
import org.whizu.dom.Content;
import org.whizu.dom.Element;
import org.whizu.dom.Markup;
import org.whizu.html.Html;
import org.whizu.html.Table;
import org.whizu.html.Tbody;
import org.whizu.html.Td;
import org.whizu.layout.Layout;
import org.whizu.widget.Widget;

public class GridLayout
extends Widget
implements Layout {
    private int numberOfColumns;
    private int column;
    private Table grid;
    private Tbody tbody;
    private Element row;

    public GridLayout() {
        this(1);
    }

    public GridLayout(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.grid = (Table)((Table)Html.table(this).attr("cellspacing", "0")).attr("cellpadding", "0");
        this.tbody = this.grid.tbody();
        this.row = null;
        this.column = 0;
    }

    @Override
    public Markup compile() {
        return this.grid;
    }

    @Override
    public GridLayout add(Component component) {
        if (this.isRendered()) {
            if (this.column == 0 || this.column == this.numberOfColumns) {
                this.row = this.tbody.tr();
                this.jQuery("$(\"table > tbody\")").append(this.row);
                this.column = 1;
            } else {
                ++this.column;
            }
            Td td = (Td)Html.td().add((Content)component);
            this.jQuery("$(\"table > tbody tr:last-child\")").append(td);
        } else {
            if (this.column == 0 || this.column == this.numberOfColumns) {
                this.row = this.tbody.tr();
                this.column = 1;
            } else {
                ++this.column;
            }
            Td td = (Td)Html.td().add((Content)component);
            this.row.add((Content)td);
        }
        return this;
    }

    @Override
    public void empty() {
        this.init();
        if (this.isRendered()) {
            this.jQuery("$(\"table > tbody\")").empty();
        }
    }

    @Override
    public void prepend(Component component) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Component component) {
        throw new UnsupportedOperationException();
    }
}

