/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.server;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whizu.annotation.AnnotationUtils;
import org.whizu.annotation.Page;
import org.whizu.jquery.EventHandler;
import org.whizu.jquery.Input;
import org.whizu.jquery.RequestContext;
import org.whizu.jquery.Session;
import org.whizu.resource.ClassPathResource;
import org.whizu.server.Configuration;
import org.whizu.server.PageFactory;
import org.whizu.server.RequestContextImpl;
import org.whizu.server.RequestImpl;
import org.whizu.server.SessionImpl;
import org.whizu.ui.Application;
import org.whizu.ui.WhizuUI;
import org.whizu.util.Chrono;

public class WhizuServlet
extends HttpServlet {
    private Logger logger = LoggerFactory.getLogger(WhizuServlet.class);
    private static final String WHIZU_SESSION = "whizu-session";
    private Configuration config = new Configuration();

    public void init(ServletConfig config) throws ServletException {
        this.logger.info("Starting the WhizuServlet");
        RequestContext.setInstance(new RequestContextImpl());
        AnnotationUtils.scan(Page.class, this.config);
        this.logger.info("WhizuServlet started");
    }

    private Session assureUserSession(HttpSession session) {
        Session userSession = (Session)session.getAttribute(WHIZU_SESSION);
        if (userSession == null) {
            userSession = new SessionImpl();
            session.setAttribute(WHIZU_SESSION, (Object)userSession);
        }
        RequestImpl.get().setSession(userSession);
        return userSession;
    }

    private String handleCss(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        String servletPath = request.getServletPath();
        String path = uri.substring(servletPath.length());
        ClassPathResource resource = new ClassPathResource(path);
        return resource.getString();
    }

    private String servePageRequest(HttpServletRequest request) {
        String uri = request.getRequestURI();
        PageFactory factory = this.config.getFactory(uri);
        if (factory != null) {
            final Application app = factory.createInstance();
            Class<?> clazz = app.getClass();
            ClassPathResource resource = new ClassPathResource(factory.getTemplate());
            try {
                String content = resource.getString();
                final String id = clazz.getName();
                content = content.replace("${id}", id);
                RequestImpl.get().getSession().addClickListener(new EventHandler(){

                    @Override
                    public String getId() {
                        return id;
                    }

                    @Override
                    public void handleEvent() {
                        app.init(new WhizuUI());
                    }
                });
                String ann = factory.getStylesheet();
                if (ann != null) {
                    String link = "<link rel='stylesheet' type='text/css' href='" + ann + "' />";
                    content = content.replace("${css}", link);
                } else {
                    content = content.replace("${css}", "");
                }
                String title = factory.getTitle();
                content = title != null ? content.replace("${title}", title) : content.replace("${title}", "Ridiculously fast web apps | Whizu");
                return content;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalArgumentException("No @Page has been defined for " + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Chrono chrono = Chrono.start();
        String content = "--";
        try {
            Session session = this.startRequest(request);
            String id = request.getParameter("id");
            if (id == null) {
                content = request.getRequestURI().endsWith(".css") ? this.handleCss(request, response) : this.servePageRequest(request);
            } else {
                session.handleEvent(id);
                content = RequestImpl.get().finish();
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Server side completed in {}ms", (Object)chrono.stop());
                this.logger.debug("Streaming script {}", (Object)content);
            }
            response.getWriter().print(content);
            response.getWriter().close();
        }
    }

    private Session startRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Session userSession = this.assureUserSession(session);
        Map parameterMap = request.getParameterMap();
        Set keys = parameterMap.keySet();
        for (String key : keys) {
            Input editable = userSession.getInput(key);
            if (editable == null) continue;
            editable.parseString(((String[])parameterMap.get(key))[0]);
        }
        return userSession;
    }
}

