/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.widget;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.whizu.annotation.Autowire;
import org.whizu.context.Ctx;
import org.whizu.dom.Component;
import org.whizu.dom.Decorator;
import org.whizu.dom.Element;
import org.whizu.dom.Identity;
import org.whizu.dom.Markup;
import org.whizu.jquery.Function;
import org.whizu.jquery.JQuery;
import org.whizu.jquery.Request;
import org.whizu.jquery.RequestContext;
import org.whizu.jquery.Session;
import org.whizu.js.Script;
import org.whizu.value.Value;
import org.whizu.value.ValueRenderer;
import org.whizu.value.ValueRendererImpl;

public abstract class Widget
implements Component,
Decorator {
    private final String id;
    private State state = State.NEW;
    private List<String> cssList = new ArrayList<String>();
    protected String width = null;
    private StringBuffer style = new StringBuffer();
    @Autowire
    public ValueRenderer renderer = new ValueRendererImpl();

    protected Widget() {
        this.autowire();
        this.id = this.getSession().next();
    }

    private void autowire() {
        Ctx.autowire(this);
    }

    @Override
    public Component css(String clazz) {
        this.cssList.add(clazz);
        if (this.isRendered()) {
            this.jQuery(this).addClass(clazz);
        }
        return this;
    }

    @Override
    public void style(String style) {
        this.style.append(style);
        if (!StringUtils.endsWith((String)style, (String)";")) {
            this.style.append(';');
        }
        if (this.isRendered()) {
            throw new UnsupportedOperationException();
        }
    }

    protected Request getRequest() {
        return RequestContext.getRequest();
    }

    protected String getSelector() {
        return "$(\"#" + this.id() + "\")";
    }

    protected Session getSession() {
        return this.getRequest().getSession();
    }

    @Override
    public String id() {
        return this.id;
    }

    public final boolean isRendered() {
        return State.RENDERED.equals((Object)this.state);
    }

    protected JQuery jQuery() {
        return this.getRequest().select("$");
    }

    protected JQuery jQuery(Identity ... components) {
        return this.getRequest().select(components);
    }

    protected JQuery jQuery(String selector) {
        return this.getRequest().select(selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String render() {
        try {
            if (this.isRendered()) {
                throw new IllegalStateException("This component is already rendered: " + this);
            }
            Markup markup = this.compile();
            if (markup == null) {
                String string = "";
                return string;
            }
            if (markup.equals(this)) {
                throw new IllegalStateException("Widget.create() must not return this - causes infinite loop");
            }
            String string = markup.render();
            return string;
        }
        finally {
            this.state = State.RENDERED;
        }
    }

    @Override
    public void width(String width) {
        this.width = width;
        if (this.isRendered()) {
            this.jQuery(this).width(width);
        }
    }

    public final Script compile(Function function) {
        return this.getRequest().compile(function);
    }

    protected final Component compile(Value value) {
        return value.render(this.renderer);
    }

    @Override
    public void decorate(Element element) {
        if (this.isRendered()) {
            throw new IllegalStateException("This component is already rendered: " + this);
        }
        element.css(this.cssList).width(this.width).style(this.style.toString());
    }

    protected void init() {
    }

    private static enum State {
        NEW,
        RENDERED;

    }
}

