/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.jquery;

import java.util.Stack;
import org.whizu.dom.Identity;
import org.whizu.jquery.Function;
import org.whizu.jquery.JQuery;
import org.whizu.jquery.JQueryImpl;
import org.whizu.jquery.Request;
import org.whizu.jquery.Session;
import org.whizu.js.Expression;
import org.whizu.js.Script;

public abstract class AbstractRequest
implements Request {
    private Stack<Script> scriptStack = new Stack();
    private Session session;

    protected AbstractRequest() {
    }

    @Override
    public final Expression addExpression(String js) {
        Expression script = new Expression(js);
        return this.addExpression(script);
    }

    protected final <T extends Expression> T addExpression(T expr) {
        if (this.scriptStack.isEmpty()) {
            Script script = new Script();
            this.scriptStack.push(script);
        }
        Script current = this.scriptStack.peek();
        current.addExpression(expr);
        return expr;
    }

    public final Script createScript() {
        this.scriptStack.push(new Script());
        return this.scriptStack.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String finish() {
        String string;
        if (this.scriptStack.isEmpty()) return "";
        try {
            String result;
            Script current = this.scriptStack.peek();
            string = result = current.toJavaScript();
            this.scriptStack.pop();
        }
        catch (Throwable throwable) {
            this.scriptStack.pop();
            throw throwable;
        }
        return string;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public final Script pop() {
        return this.scriptStack.pop();
    }

    @Override
    public final JQuery select(Identity ... objs) {
        JQueryImpl query = new JQueryImpl(objs);
        return this.addExpression(query);
    }

    @Override
    public final JQuery select(String selector) {
        JQueryImpl query = new JQueryImpl(selector);
        return this.addExpression(query);
    }

    public final void setSession(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Script compile(Function function) {
        try {
            Script script = this.createScript();
            function.execute();
            Script script2 = script;
            return script2;
        }
        finally {
            this.pop();
        }
    }

    @Override
    public String define(Function f) {
        return "function(" + f.params + ") { " + this.compile(f).toJavaScript() + " }";
    }

    @Override
    public String evaluate(Function f) {
        String result = this.compile(f).toJavaScript();
        return result.substring(0, result.length() - 1);
    }
}

