/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.jquery;

import org.apache.commons.lang.StringEscapeUtils;
import org.whizu.annotation.Bean;
import org.whizu.dom.Content;
import org.whizu.dom.Identity;
import org.whizu.jquery.Function;
import org.whizu.jquery.JQuery;
import org.whizu.jquery.RequestContext;
import org.whizu.js.Expression;
import org.whizu.js.Script;

@Bean(value="JQuery")
class JQueryImpl
extends Expression
implements JQuery {
    private String selector = "";

    JQueryImpl(Identity element) {
        this.selector = this.getSelector(element);
    }

    JQueryImpl(Identity ... elements) {
        this.selector = this.getSelector(elements);
    }

    JQueryImpl(String selector) {
        this.selector = selector;
    }

    public JQueryImpl() {
    }

    @Override
    public JQuery addClass(String style) {
        return this.call("addClass", style);
    }

    @Override
    public JQuery after(String ... content) {
        return this.call("after", content);
    }

    @Override
    public JQuery append(Content content) {
        return this.call("append", content);
    }

    @Override
    public JQuery append(String ... content) {
        return this.call("append", content);
    }

    @Override
    public JQuery appendTo(String target) {
        return this.call("appendTo", target);
    }

    @Override
    public String attr(String attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JQuery before(String ... content) {
        return this.call("before", content);
    }

    @Override
    public JQuery button() {
        return this.call("button");
    }

    @Override
    public JQuery call(String function) {
        return this.concat(".", function, "()");
    }

    @Override
    public JQuery call(String function, String arg) {
        return this.concat(".", function, "(\"", arg, "\")");
    }

    private JQuery call(String function, Content arg) {
        this.concat(".", function, "(\"");
        this.add(arg);
        this.concat("\")");
        return this;
    }

    @Override
    public JQuery call(String function, String ... args) {
        String arguments = "\"" + args[0] + "\"";
        for (int i = 1; i < args.length; ++i) {
            arguments = arguments.concat(",").concat("'").concat(args[i]).concat("'");
        }
        return this.concat(".", function, "(", arguments, ")");
    }

    public JQuery call(String function, String arg0, String ... args) {
        String arguments = "'" + arg0 + "'";
        for (int i = 0; i < args.length; ++i) {
            arguments = arguments.concat(",").concat("'").concat(args[i]).concat("'");
        }
        return this.concat(".", function, "(", arguments, ")");
    }

    @Override
    public JQuery callunquoted(String function, String arglist) {
        return this.concat(".", function, "(", arglist, ")");
    }

    @Override
    public JQuery click(Function function) {
        Script script = RequestContext.getRequest().compile(function);
        return this.concat(".", "click", "(function(event) { ", script.toJavaScript(), " })");
    }

    @Override
    public JQuery closest(String name) {
        return this.call("closest", name);
    }

    @Override
    public JQuery concat(String ... js) {
        for (String part : js) {
            this.add(part);
        }
        return this;
    }

    @Override
    public JQuery document() {
        return new JQueryImpl("$('#y-body')");
    }

    @Override
    public JQuery empty() {
        return this.call("empty");
    }

    @Override
    public JQuery find(String selector) {
        return this.concat(".", "find(", this.quote(selector), ")");
    }

    @Override
    public JQuery get(String url, Function data, Function callback, String type) {
        return this.concat(".", "get(", this.quote(url), ", ", RequestContext.getRequest().evaluate(data), ", ", RequestContext.getRequest().define(callback), ", ", this.quote(type), ")");
    }

    private String getSelector(Identity ... objs) {
        String selector = "$(\"";
        int i = 0;
        for (Identity component : objs) {
            if (i > 0) {
                selector = selector + ",";
            }
            selector = selector + "#" + component.id();
            ++i;
        }
        selector = selector + "\")";
        return selector;
    }

    @Override
    public JQuery html(String arg) {
        String html = StringEscapeUtils.escapeJavaScript((String)arg);
        return this.call("html", html);
    }

    @Override
    public JQuery insertAfter(String target) {
        return this.call("insertAfter", target);
    }

    @Override
    public JQuery insertBefore(String target) {
        return this.call("insertBefore", target);
    }

    @Override
    public JQuery prepend(String arg) {
        return this.call("prepend", arg);
    }

    @Override
    public JQuery prepend(String ... content) {
        return this.call("prepend", content);
    }

    @Override
    public JQuery prependTo(String target) {
        return this.call("prependTo", target);
    }

    private String quote(String type) {
        return "'".concat(type).concat("'");
    }

    @Override
    public JQuery remove() {
        return this.call("remove");
    }

    @Override
    public JQuery remove(String selector) {
        return this.call("remove", selector);
    }

    @Override
    public JQuery replaceAll(String target) {
        return this.call("replaceAll", target);
    }

    @Override
    public JQuery replaceWith(String newContent) {
        return this.call("replaceWith", newContent);
    }

    @Override
    public JQuery serialize() {
        return this.call("serialize");
    }

    @Override
    public JQuery text(String arg) {
        return this.call("text", arg);
    }

    @Override
    public JQuery toggle() {
        return this.call("toggle");
    }

    @Override
    public String toJavaScript() {
        return this.selector.concat(super.toJavaScript());
    }

    @Override
    public JQuery trigger(String event) {
        return this.call("trigger", event);
    }

    @Override
    public JQuery val(String arg) {
        return this.call("val", arg);
    }

    @Override
    public JQuery width(String value) {
        return this.call("width", value);
    }

    @Override
    public JQuery wrap(String wrappingElement) {
        return this.call("wrap", wrappingElement);
    }

    @Override
    public JQuery wrapAll(String wrappingElement) {
        return this.call("wrapAll", wrappingElement);
    }

    @Override
    public JQuery wrapInner(String wrappingElement) {
        return this.call("wrapInner", wrappingElement);
    }

    @Override
    public JQuery prepend(Content content) {
        return this.prepend(content.render());
    }

    @Override
    public JQuery firstOfType(String element) {
        return this.call("filter", element);
    }

    @Override
    public JQuery lastChild(String element) {
        return this.call("filter", element + ":last-child");
    }
}

