/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.server;

import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whizu.annotation.Body;
import org.whizu.annotation.Css;
import org.whizu.annotation.Style;
import org.whizu.annotation.Stylesheet;
import org.whizu.annotation.Template;
import org.whizu.annotation.Title;
import org.whizu.dom.Component;
import org.whizu.server.PageFactory;
import org.whizu.ui.Application;

public class ApplicationEnhancer {
    private Logger log = LoggerFactory.getLogger(ApplicationEnhancer.class);

    public PageFactory createFactory(String className) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Enhancing class " + className);
            }
            ClassPool classPool = ClassPool.getDefault();
            CtClass ctClass = classPool.get(className);
            String stylesheet = null;
            if (ctClass.hasAnnotation(Stylesheet.class)) {
                stylesheet = ((Stylesheet)ctClass.getAnnotation(Stylesheet.class)).value();
            }
            String title = "Ridiculously fast web apps | Whizu";
            if (ctClass.hasAnnotation(Title.class)) {
                title = ((Title)ctClass.getAnnotation(Title.class)).value();
            }
            String template = null;
            if (ctClass.hasAnnotation(Template.class)) {
                template = ((Template)ctClass.getAnnotation(Template.class)).value();
            }
            CtMethod[] ctMethods = ctClass.getDeclaredMethods();
            ArrayList<CtMethod> methodsToDo = new ArrayList<CtMethod>();
            for (CtMethod method : ctMethods) {
                if (method.hasAnnotation(Css.class) || method.hasAnnotation(Style.class)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Enhancing method " + method);
                    }
                    methodsToDo.add(method);
                }
                if (!method.hasAnnotation(Body.class)) continue;
                this.log.debug("Found @Body");
            }
            for (CtMethod method : methodsToDo) {
                Style sannot;
                Css annot = (Css)method.getAnnotation(Css.class);
                if (annot != null) {
                    method.insertAfter("org.whizu.server.ApplicationEnhancer.doIt(\"" + annot.value()[0] + "\", $_);");
                }
                if ((sannot = (Style)method.getAnnotation(Style.class)) == null) continue;
                method.insertAfter("org.whizu.server.ApplicationEnhancer.style(\"" + sannot.value()[0] + "\", $_);");
            }
            this.fixInnerClasses(ctClass);
            ClassFile ccFile = ctClass.getClassFile();
            ConstPool constpool = ccFile.getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation annot = new Annotation("org.whizu.annotation.Bean", constpool);
            annot.addMemberValue("value", (MemberValue)new StringMemberValue("hello", ccFile.getConstPool()));
            attr.addAnnotation(annot);
            ccFile.addAttribute((AttributeInfo)attr);
            Class<Application> newClass = this.getEnhancedClass(ctClass);
            PageFactory factory = new PageFactory(newClass);
            factory.setTitle(title);
            factory.setStylesheet(stylesheet);
            if (template != null) {
                factory.setTemplate(template);
            }
            PageFactory pageFactory = factory;
            return pageFactory;
        }
        catch (ClassNotFoundException | CannotCompileException | NotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void fixInnerClasses(CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtClass[] nested;
        for (CtClass n : nested = ctClass.getNestedClasses()) {
            n.toClass();
            this.fixInnerClasses(n);
        }
    }

    private Class<Application> getEnhancedClass(CtClass ctClass) {
        try {
            return ctClass.toClass();
        }
        catch (CannotCompileException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Object doIt(Object arg) {
        return arg;
    }

    public static Object doIt(String css, Object arg) {
        if (arg instanceof Component) {
            ((Component)arg).css(css);
        }
        return arg;
    }

    public static Object style(String css, Object arg) {
        if (arg instanceof Component) {
            ((Component)arg).style(css);
        }
        return arg;
    }
}

