/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.server;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whizu.annotation.Page;
import org.whizu.annotation.TypeReporter;
import org.whizu.server.ApplicationEnhancer;
import org.whizu.server.PageFactory;
import org.whizu.ui.Application;

class Configuration
implements TypeReporter<Page> {
    private Logger log = LoggerFactory.getLogger(Configuration.class);
    private Map<String, PageFactory> applicationFactoryMap = new HashMap<String, PageFactory>();

    Configuration() {
    }

    public void addApplication(String uri, PageFactory application) {
        this.applicationFactoryMap.put(uri, application);
        this.applicationFactoryMap.put(uri + "/", application);
    }

    public PageFactory getFactory(String uri) {
        return this.applicationFactoryMap.get(uri);
    }

    public Application getApplication(String uri) {
        PageFactory factory = this.applicationFactoryMap.get(uri);
        if (factory != null) {
            return factory.createInstance();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("No @Page has been defined for uri " + uri);
        }
        return null;
    }

    @Override
    public void report(Page annotation, String className) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("@Page(\"" + annotation.value() + "\") on " + className);
        }
        ApplicationEnhancer enhancer = new ApplicationEnhancer();
        this.addApplication(annotation.value(), enhancer.createFactory(className));
    }
}

