/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.server;

import java.util.HashMap;
import java.util.Map;
import org.whizu.jquery.EventHandler;
import org.whizu.jquery.Input;
import org.whizu.jquery.Session;
import org.whizu.ui.Application;
import org.whizu.ui.WhizuUI;

class SessionImpl
implements Session {
    private static int sessionCount = 0;
    private int componentCount = 0;
    private Map<String, Object> attrMap = new HashMap<String, Object>();
    private Map<String, EventHandler> eventHandlerMap = new HashMap<String, EventHandler>();
    private Map<String, Input> inputMap = new HashMap<String, Input>();

    SessionImpl() {
        ++sessionCount;
    }

    @Override
    public void addClickListener(EventHandler listener) {
        this.eventHandlerMap.put(listener.getId(), listener);
    }

    @Override
    public void addInput(Input input) {
        this.inputMap.put(input.id(), input);
    }

    @Override
    public Object getAttribute(String name) {
        return this.attrMap.get(name);
    }

    @Override
    public EventHandler getEventHandler(String id) {
        return this.eventHandlerMap.get(id);
    }

    @Override
    public Input getInput(String id) {
        return this.inputMap.get(id);
    }

    @Override
    public int getSessionCount() {
        return sessionCount;
    }

    @Override
    public void handleEvent(String id) {
        EventHandler listener = this.getEventHandler(id);
        if (listener != null) {
            listener.handleEvent();
        } else {
            try {
                Class<?> clazz = Class.forName(id);
                Application app = (Application)clazz.newInstance();
                app.init(new WhizuUI());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String next() {
        return "c" + this.componentCount++;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attrMap.put(name, value);
    }
}

