/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.lang.reflect.FieldUtils;
import org.whizu.annotation.Name;
import org.whizu.layout.GridLayout;
import org.whizu.ui.Action;
import org.whizu.ui.ClickListener;
import org.whizu.ui.Form;
import org.whizu.ui.FormImpl;
import org.whizu.ui.WhizuUI;
import org.whizu.value.StringValue;
import org.whizu.value.Value;

public class FormBuilder {
    private Form form;
    private GridLayout layout;
    private WhizuUI ui = new WhizuUI();

    public FormBuilder() {
        this(1);
    }

    public FormBuilder(int columns) {
        this.form = new FormImpl();
        this.layout = new GridLayout(2 * columns);
    }

    public void addButton(String caption, final Action action) {
        this.addButton(caption, new ClickListener(){

            @Override
            public void click() {
                action.performAction();
            }
        });
    }

    public void addButton(String caption, ClickListener listener) {
        this.layout.skip();
        this.layout.add(this.ui.createLabel(caption).css("submit").addClickListener(listener));
    }

    public void addField(Object model, String fieldName) {
        this.addTextField(model, fieldName);
    }

    public void addValue(Object model, Value value) {
        this.layout.add(this.ui.createLabel(this.getLabelName(model, value)));
        this.layout.add(this.ui.createTextField(value));
    }

    private String getLabelName(Object model, Value value) {
        try {
            Field[] fields;
            for (Field field : fields = model.getClass().getFields()) {
                Object obj = FieldUtils.readField((Field)field, (Object)model, (boolean)true);
                if (obj != value) continue;
                if (field.isAnnotationPresent(Name.class)) {
                    return field.getAnnotation(Name.class).value();
                }
                return field.getName();
            }
            return value.getName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addTextField(Object model, String fieldName) {
        this.layout.add(this.ui.createLabel(fieldName));
        this.layout.add(this.ui.createTextField(this.getValue(model, fieldName)));
    }

    public Form create() {
        this.form.add(this.layout);
        return this.form;
    }

    private String get(Object model, String fieldName) {
        try {
            Method getter = model.getClass().getMethod("get" + fieldName, new Class[0]);
            return (String)getter.invoke(model, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private StringValue getValue(final Object model, final String fieldName) {
        String s = this.get(model, fieldName);
        final StringValue value = (StringValue)new StringValue(fieldName).set(s);
        value.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                FormBuilder.this.set(model, fieldName, value.getValue());
            }
        });
        return value;
    }

    private void set(Object model, String fieldName, Object value) {
        try {
            Method setter = model.getClass().getMethod("set" + fieldName, String.class);
            setter.invoke(model, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

