/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.whizu.dom.Component;
import org.whizu.dom.Content;
import org.whizu.dom.Element;
import org.whizu.dom.Foreach;
import org.whizu.dom.Markup;
import org.whizu.html.Html;
import org.whizu.html.Tr;
import org.whizu.ui.Table;
import org.whizu.widget.Widget;

class TableImpl
extends Widget
implements Table {
    private String title;
    private List<String> columnList = new ArrayList<String>();
    private Map<Object, Component[]> rows = new HashMap<Object, Component[]>();

    TableImpl(String title) {
        this.title = title;
    }

    @Override
    public void addColumn(String name) {
        this.columnList.add(name);
    }

    @Override
    public void addRow(Object key, Component ... components) {
        this.rows.put(key, components);
        if (this.isRendered()) {
            Element tr = ((Tr)Html.tr().width(this.width)).style("word-wrap", "break-word");
            for (Component value : components) {
                tr.add((Content)Html.td().style("word-wrap", "break-word").add((Content)value));
            }
            this.jQuery(this).find("tbody").prepend(tr);
        }
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public Markup compile() {
        this.jQuery(this).closest("div").trigger("create");
        return ((org.whizu.html.Table)Html.table(this.id()).attr("data-role", "table")).css("ui-responsive").css("table-stroke").attr("data-inset", "true").attr("data-mini", "true").attr("data-mode", "columntoggle").width(this.width).style("word-wrap", "break-word").add(Html.thead().add((Content)Html.tr().add(new Foreach<String>(this.columnList){

            @Override
            public Content compile(String item) {
                return Html.th(item);
            }
        })), Html.tbody().add(new Foreach<Component[]>(this.rows.values()){

            @Override
            public Content compile(Component[] item) {
                Element tr = ((Tr)Html.tr().width(TableImpl.this.width)).style("word-wrap", "break-word");
                for (Component value : item) {
                    tr.add((Content)Html.td().style("word-wrap", "break-word").add((Content)value));
                }
                return tr;
            }
        }));
    }
}

