/*
 * Decompiled with CFR 0.152.
 */
package org.whizu.value;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.whizu.value.Value;

public abstract class AbstractValue<T>
implements Value<T> {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean isReadOnly;
    public final String name;
    private T value;

    public AbstractValue(String name) {
        this.name = name;
        this.setValue(this.getDefaultValue());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, T oldValue, T newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected abstract T getDefaultValue();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public void setReadOnly(boolean newStatus) {
        this.isReadOnly = newStatus;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.firePropertyChange("value", this.value, this.value);
    }

    public String toString() {
        return "" + this.getValue();
    }

    @Override
    public void refresh(Value<T> value) {
        this.setValue(value.getValue());
    }
}

