/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.api.commentprocessor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.UnresolvedExpressionException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.proxy.ContextFactory;
import org.wickedsource.docxstamper.proxy.ProxyException;
import org.wickedsource.docxstamper.replace.ParagraphWrapper;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.walk.coordinates.BaseCoordinatesWalker;
import org.wickedsource.docxstamper.walk.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.walk.coordinates.RunCoordinates;

public class CommentProcessorRegistry {
    private Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private Map<ICommentProcessor, Class<?>> commentProcessorInterfaces = new HashMap();
    private List<ICommentProcessor> commentProcessors = new ArrayList<ICommentProcessor>();
    private ExpressionResolver expressionResolver = new ExpressionResolver();
    private ExpressionUtil expressionUtil = new ExpressionUtil();
    private PlaceholderReplacer placeholderReplacer;
    private boolean failOnInvalidExpression = true;

    public CommentProcessorRegistry(PlaceholderReplacer placeholderReplacer) {
        this.placeholderReplacer = placeholderReplacer;
    }

    public void registerCommentProcessor(Class<?> interfaceClass, ICommentProcessor commentProcessor) {
        this.commentProcessorInterfaces.put(commentProcessor, interfaceClass);
        this.commentProcessors.add(commentProcessor);
    }

    public <T> void runProcessors(final WordprocessingMLPackage document, final T contextRoot) {
        final Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                CommentProcessorRegistry.this.runProcessorsOnParagraphComment(document, comments, contextRoot, paragraphCoordinates);
                CommentProcessorRegistry.this.runProcessorsOnInlineContent(contextRoot, paragraphCoordinates);
            }

            @Override
            protected CommentWrapper onRun(RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
                return CommentProcessorRegistry.this.runProcessorsOnRunComment(document, comments, contextRoot, runCoordinates, paragraphCoordinates);
            }
        };
        walker.walk();
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.commitChanges(document);
        }
    }

    private <T> void runProcessorsOnInlineContent(T contextRoot, ParagraphCoordinates paragraphCoordinates) {
        ParagraphWrapper paragraph = new ParagraphWrapper(paragraphCoordinates.getParagraph());
        List<String> processorExpressions = this.expressionUtil.findProcessorExpressions(paragraph.getText());
        for (String processorExpression : processorExpressions) {
            String strippedExpression = this.expressionUtil.stripExpression(processorExpression);
            Throwable latestException = null;
            boolean expressionResolvedSuccessfully = false;
            for (ICommentProcessor processor : this.commentProcessors) {
                try {
                    Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                    ContextFactory<T> contextFactory = new ContextFactory<T>();
                    Object contextRootProxy = contextFactory.createProxy(contextRoot, commentProcessorInterface, processor);
                    processor.setCurrentParagraphCoordinates(paragraphCoordinates);
                    this.expressionResolver.resolveExpression(strippedExpression, contextRootProxy);
                    this.placeholderReplacer.replace(paragraph, processorExpression, null);
                    this.logger.debug(String.format("Processor expression '%s' has been successfully processed by comment processor %s.", processorExpression, processor.getClass()));
                    expressionResolvedSuccessfully = true;
                }
                catch (SpelEvaluationException | SpelParseException e) {
                    latestException = e;
                    this.logger.warn(String.format("Skipping processor expression '%s' because it can not be resolved by comment processor %s. Reason: %s. Set log level to TRACE to view Stacktrace.", processorExpression, processor.getClass(), e.getMessage()));
                    this.logger.trace("Reason for skipping processor expression: ", e);
                }
                catch (ProxyException e) {
                    throw new DocxStamperException(String.format("Could not create a proxy around context root object of class %s", contextRoot.getClass()), e);
                }
            }
            if (!this.failOnInvalidExpression || expressionResolvedSuccessfully) continue;
            throw new UnresolvedExpressionException(strippedExpression, latestException);
        }
    }

    private <T> void runProcessorsOnParagraphComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T contextRoot, ParagraphCoordinates paragraphCoordinates) {
        Throwable latestException = null;
        boolean expressionResolvedSuccessfully = false;
        Comments.Comment comment = CommentUtil.getCommentFor((ContentAccessor)paragraphCoordinates.getParagraph(), document);
        if (comment == null) {
            return;
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (ICommentProcessor processor : this.commentProcessors) {
            try {
                Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                ContextFactory<T> contextFactory = new ContextFactory<T>();
                Object contextRootProxy = contextFactory.createProxy(contextRoot, commentProcessorInterface, processor);
                processor.setCurrentParagraphCoordinates(paragraphCoordinates);
                CommentWrapper commentWrapper = comments.get(comment.getId());
                try {
                    this.expressionResolver.resolveExpression(commentString, contextRootProxy);
                    CommentUtil.deleteComment(commentWrapper);
                    this.logger.debug(String.format("Comment '%s' has been successfully processed by comment processor %s.", commentString, processor.getClass()));
                    expressionResolvedSuccessfully = true;
                    break;
                }
                catch (SpelEvaluationException | SpelParseException e) {
                    latestException = e;
                    this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by comment processor %s. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, processor.getClass(), e.getMessage()));
                    this.logger.trace("Reason for skipping comment: ", e);
                }
            }
            catch (ProxyException e) {
                throw new DocxStamperException(String.format("Could not create a proxy around context root object of class %s", contextRoot.getClass()), e);
            }
        }
        if (this.failOnInvalidExpression && !expressionResolvedSuccessfully) {
            throw new UnresolvedExpressionException(commentString, latestException);
        }
    }

    private <T> CommentWrapper runProcessorsOnRunComment(WordprocessingMLPackage document, Map<BigInteger, CommentWrapper> comments, T contextRoot, RunCoordinates runCoordinates, ParagraphCoordinates paragraphCoordinates) {
        Throwable latestException = null;
        boolean expressionResolvedSuccessfully = false;
        Comments.Comment comment = CommentUtil.getCommentAround(runCoordinates.getRun(), document);
        if (comment == null) {
            return null;
        }
        String commentString = CommentUtil.getCommentString(comment);
        for (ICommentProcessor processor : this.commentProcessors) {
            try {
                Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                ContextFactory<T> contextFactory = new ContextFactory<T>();
                Object contextRootProxy = contextFactory.createProxy(contextRoot, commentProcessorInterface, processor);
                processor.setCurrentRunCoordinates(runCoordinates);
                processor.setCurrentParagraphCoordinates(paragraphCoordinates);
                CommentWrapper commentWrapper = comments.get(comment.getId());
                try {
                    this.expressionResolver.resolveExpression(commentString, contextRootProxy);
                    this.logger.debug(String.format("Comment '%s' has been successfully processed by comment processor %s.", commentString, processor.getClass()));
                    expressionResolvedSuccessfully = true;
                    return commentWrapper;
                }
                catch (SpelEvaluationException | SpelParseException e) {
                    latestException = e;
                    this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by comment processor %s. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, processor.getClass(), e.getMessage()));
                    this.logger.trace("Reason for skipping comment: ", e);
                }
            }
            catch (ProxyException e) {
                throw new DocxStamperException(String.format("Could not create a proxy around context root object of class %s", contextRoot.getClass()), e);
            }
        }
        if (this.failOnInvalidExpression && !expressionResolvedSuccessfully) {
            throw new UnresolvedExpressionException(commentString, latestException);
        }
        return null;
    }

    public boolean isFailOnInvalidExpression() {
        return this.failOnInvalidExpression;
    }

    public void setFailOnInvalidExpression(boolean failOnInvalidExpression) {
        this.failOnInvalidExpression = failOnInvalidExpression;
    }

    public void reset() {
        for (ICommentProcessor processor : this.commentProcessors) {
            processor.reset();
        }
    }
}

