/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.walk;

import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;

public abstract class DocumentWalker {
    private ContentAccessor contentAccessor;

    public DocumentWalker(ContentAccessor contentAccessor) {
        this.contentAccessor = contentAccessor;
    }

    public void walk() {
        for (Object contentElement : this.contentAccessor.getContent()) {
            Object unwrappedObject = XmlUtils.unwrap(contentElement);
            if (unwrappedObject instanceof P) {
                P p = (P)unwrappedObject;
                this.walkParagraph(p);
                continue;
            }
            if (unwrappedObject instanceof Tbl) {
                Tbl table = (Tbl)unwrappedObject;
                this.walkTable(table);
                continue;
            }
            if (unwrappedObject instanceof Tr) {
                Tr row = (Tr)unwrappedObject;
                this.walkTableRow(row);
                continue;
            }
            if (!(unwrappedObject instanceof Tc)) continue;
            Tc cell = (Tc)unwrappedObject;
            this.walkTableCell(cell);
        }
    }

    private void walkTable(Tbl table) {
        this.onTable(table);
        for (Object contentElement : table.getContent()) {
            if (!(XmlUtils.unwrap(contentElement) instanceof Tr)) continue;
            Tr row = (Tr)contentElement;
            this.walkTableRow(row);
        }
    }

    private void walkTableRow(Tr row) {
        this.onTableRow(row);
        for (Object rowContentElement : row.getContent()) {
            if (!(XmlUtils.unwrap(rowContentElement) instanceof Tc)) continue;
            Tc cell = rowContentElement instanceof Tc ? (Tc)rowContentElement : (Tc)((JAXBElement)rowContentElement).getValue();
            this.walkTableCell(cell);
        }
    }

    private void walkTableCell(Tc cell) {
        this.onTableCell(cell);
        for (Object cellContentElement : cell.getContent()) {
            if (XmlUtils.unwrap(cellContentElement) instanceof P) {
                P p = (P)cellContentElement;
                this.walkParagraph(p);
                continue;
            }
            if (!(XmlUtils.unwrap(cellContentElement) instanceof Tbl)) continue;
            Tbl nestedTable = (Tbl)((JAXBElement)cellContentElement).getValue();
            this.walkTable(nestedTable);
        }
    }

    private void walkParagraph(P p) {
        this.onParagraph(p);
        for (Object element : p.getContent()) {
            if (XmlUtils.unwrap(element) instanceof CommentRangeStart) {
                CommentRangeStart commentRangeStart = (CommentRangeStart)element;
                this.onCommentRangeStart(commentRangeStart);
                continue;
            }
            if (!(XmlUtils.unwrap(element) instanceof CommentRangeEnd)) continue;
            CommentRangeEnd commentRangeEnd = (CommentRangeEnd)element;
            this.onCommentRangeEnd(commentRangeEnd);
        }
    }

    protected abstract void onParagraph(P var1);

    protected abstract void onTable(Tbl var1);

    protected abstract void onTableCell(Tc var1);

    protected abstract void onTableRow(Tr var1);

    protected abstract void onCommentRangeStart(CommentRangeStart var1);

    protected abstract void onCommentRangeEnd(CommentRangeEnd var1);
}

