/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace;

import java.util.ArrayList;
import java.util.List;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.wickedsource.docxstamper.replace.IndexedRun;
import org.wickedsource.docxstamper.util.RunUtil;

public class ParagraphWrapper {
    private int currentPosition = 0;
    private List<IndexedRun> runs = new ArrayList<IndexedRun>();
    private P paragraph;

    public ParagraphWrapper(P paragraph) {
        this.paragraph = paragraph;
        this.recalculateRuns();
    }

    public void recalculateRuns() {
        this.currentPosition = 0;
        this.runs.clear();
        int index = 0;
        for (Object contentElement : this.paragraph.getContent()) {
            if (contentElement instanceof R && !"".equals(RunUtil.getText((R)contentElement))) {
                this.addRun((R)contentElement, index);
            }
            ++index;
        }
    }

    private void addRun(R run, int index) {
        int startIndex = this.currentPosition;
        int endIndex = this.currentPosition + RunUtil.getText(run).length() - 1;
        this.runs.add(new IndexedRun(startIndex, endIndex, index, run));
        this.currentPosition = endIndex + 1;
    }

    public int cleanPlaceholder(String placeholder) {
        int replacementIndex = 0;
        String text = this.getText();
        int matchStartIndex = text.indexOf(placeholder);
        int matchEndIndex = matchStartIndex + placeholder.length() - 1;
        List<IndexedRun> affectedRuns = this.getAffectedRuns(matchStartIndex, matchEndIndex);
        String affectedRunsText = this.getText(affectedRuns);
        int affectedRunsMatchStartIndex = affectedRunsText.indexOf(placeholder);
        int affectedRunsMatchEndIndex = affectedRunsMatchStartIndex + placeholder.length() - 1;
        boolean isFirstRun = true;
        boolean isLastRun = affectedRuns.size() == 1;
        int currentRun = 0;
        for (IndexedRun run : affectedRuns) {
            if (isFirstRun && isLastRun) {
                if (placeholder.length() == RunUtil.getText(run.getRun()).length()) {
                    this.paragraph.getContent().remove(run.getRun());
                    replacementIndex = run.getIndexInParent();
                    this.recalculateRuns();
                } else {
                    String runText = RunUtil.getText(run.getRun());
                    R run1 = RunUtil.create(runText.substring(0, affectedRunsMatchStartIndex), this.paragraph);
                    R run2 = RunUtil.create(runText.substring(affectedRunsMatchEndIndex + 1), this.paragraph);
                    this.paragraph.getContent().add(run.getIndexInParent(), run2);
                    this.paragraph.getContent().add(run.getIndexInParent(), run1);
                    this.paragraph.getContent().remove(run.getRun());
                    replacementIndex = run.getIndexInParent() + 1;
                    this.recalculateRuns();
                }
            } else if (isFirstRun) {
                run.replace(matchStartIndex, matchEndIndex, "");
                replacementIndex = run.getIndexInParent();
            } else if (isLastRun) {
                run.replace(run.getStartIndex(), affectedRunsMatchEndIndex, "");
            } else {
                this.paragraph.getContent().remove(run.getRun());
                this.recalculateRuns();
            }
            isFirstRun = false;
            isLastRun = ++currentRun == affectedRuns.size() - 1;
        }
        return replacementIndex;
    }

    private List<IndexedRun> getAffectedRuns(int startIndex, int endIndex) {
        ArrayList<IndexedRun> affectedRuns = new ArrayList<IndexedRun>();
        for (IndexedRun run : this.runs) {
            if (!run.isTouchedByRange(startIndex, endIndex)) continue;
            affectedRuns.add(run);
        }
        return affectedRuns;
    }

    public String getText() {
        return this.getText(this.runs);
    }

    private String getText(List<IndexedRun> runs) {
        StringBuilder builder = new StringBuilder();
        for (IndexedRun run : runs) {
            builder.append(RunUtil.getText(run.getRun()));
        }
        return builder.toString();
    }

    public List<R> getRuns() {
        ArrayList<R> resultList = new ArrayList<R>();
        for (IndexedRun run : this.runs) {
            resultList.add(run.getRun());
        }
        return resultList;
    }

    public String toString() {
        return this.getText();
    }
}

