/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.math.BigInteger;
import java.util.ArrayList;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.replace.ParagraphWrapper;

public class CommentUtil {
    private static Logger logger = LoggerFactory.getLogger(CommentUtil.class);

    public static Comments.Comment getCommentFor(ContentAccessor object, WordprocessingMLPackage document) throws Docx4JException {
        for (Object contentObject : object.getContent()) {
            if (!(contentObject instanceof CommentRangeStart)) continue;
            try {
                BigInteger id = ((CommentRangeStart)contentObject).getId();
                CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
                Comments comments = (Comments)commentsPart.getContents();
                for (Comments.Comment comment : comments.getComment()) {
                    if (!comment.getId().equals(id)) continue;
                    return comment;
                }
            }
            catch (InvalidFormatException e) {
                logger.warn(String.format("Error while searching comment. Skipping object %s.", object), (Throwable)e);
            }
        }
        return null;
    }

    public static String getCommentStringFor(ContentAccessor object, WordprocessingMLPackage document) throws Docx4JException {
        Comments.Comment comment = CommentUtil.getCommentFor(object, document);
        return CommentUtil.getCommentString(comment);
    }

    public static String getCommentString(Comments.Comment comment) {
        String commentString = "";
        for (Object commentChildObject : comment.getContent()) {
            if (!(commentChildObject instanceof P)) continue;
            commentString = commentString + new ParagraphWrapper((P)commentChildObject).getText();
        }
        return commentString;
    }

    public static void deleteCommentFromParagraph(P paragraph, Comments.Comment comment) {
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        int index = 0;
        for (Object contentObject : paragraph.getContent()) {
            BigInteger commentId = null;
            if (contentObject instanceof CommentRangeStart) {
                commentId = ((CommentRangeStart)contentObject).getId();
            }
            if (contentObject instanceof CommentRangeEnd) {
                commentId = ((CommentRangeEnd)contentObject).getId();
            }
            if (contentObject instanceof R) {
                for (Object runContentObject : ((R)contentObject).getContent()) {
                    Object unwrapped = XmlUtils.unwrap(runContentObject);
                    if (!(unwrapped instanceof R.CommentReference)) continue;
                    commentId = ((R.CommentReference)unwrapped).getId();
                }
            }
            if (comment.getId().equals(commentId)) {
                indicesToRemove.add(index);
            }
            ++index;
        }
        int indexCorrection = 0;
        for (Integer indexToRemove : indicesToRemove) {
            paragraph.getContent().remove(indexToRemove - indexCorrection);
            ++indexCorrection;
        }
    }
}

