/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.walk.coordinates;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.P;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.wickedsource.docxstamper.walk.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.walk.coordinates.TableCellCoordinates;
import org.wickedsource.docxstamper.walk.coordinates.TableCoordinates;
import org.wickedsource.docxstamper.walk.coordinates.TableRowCoordinates;

public abstract class CoordinatesWalker {
    private WordprocessingMLPackage document;

    public CoordinatesWalker(WordprocessingMLPackage document) {
        this.document = document;
    }

    public void walk() {
        RelationshipsPart relationshipsPart = this.document.getMainDocumentPart().getRelationshipsPart();
        Relationship headerRel = relationshipsPart.getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header");
        if (headerRel != null) {
            HeaderPart headerPart = (HeaderPart)relationshipsPart.getPart(headerRel);
            this.walkContent(headerPart.getContent());
        }
        this.walkContent(this.document.getMainDocumentPart().getContent());
        Relationship footerRel = relationshipsPart.getRelationshipByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer");
        if (footerRel != null) {
            FooterPart footerPart = (FooterPart)relationshipsPart.getPart(footerRel);
            this.walkContent(footerPart.getContent());
        }
    }

    private void walkContent(List<Object> contentElements) {
        int elementIndex = 0;
        for (Object contentElement : contentElements) {
            Object unwrappedObject = XmlUtils.unwrap((Object)contentElement);
            if (unwrappedObject instanceof P) {
                P p = (P)unwrappedObject;
                ParagraphCoordinates coordinates = new ParagraphCoordinates(p, elementIndex);
                this.onParagraph(coordinates);
            } else if (unwrappedObject instanceof Tbl) {
                Tbl table = (Tbl)unwrappedObject;
                TableCoordinates tableCoordinates = new TableCoordinates(table, elementIndex);
                this.walkTable(tableCoordinates);
            }
            ++elementIndex;
        }
    }

    private void walkTable(TableCoordinates tableCoordinates) {
        this.onTable(tableCoordinates);
        int rowIndex = 0;
        for (Object contentElement : tableCoordinates.getTable().getContent()) {
            if (XmlUtils.unwrap(contentElement) instanceof Tr) {
                Tr row = (Tr)contentElement;
                TableRowCoordinates rowCoordinates = new TableRowCoordinates(row, rowIndex, tableCoordinates);
                this.walkTableRow(rowCoordinates);
            }
            ++rowIndex;
        }
    }

    private void walkTableRow(TableRowCoordinates rowCoordinates) {
        this.onTableRow(rowCoordinates);
        int cellIndex = 0;
        for (Object rowContentElement : rowCoordinates.getRow().getContent()) {
            if (XmlUtils.unwrap(rowContentElement) instanceof Tc) {
                Tc cell = (Tc)((JAXBElement)rowContentElement).getValue();
                TableCellCoordinates cellCoordinates = new TableCellCoordinates(cell, cellIndex, rowCoordinates);
                this.walkTableCell(cellCoordinates);
            }
            ++cellIndex;
        }
    }

    private void walkTableCell(TableCellCoordinates cellCoordinates) {
        this.onTableCell(cellCoordinates);
        int elementIndex = 0;
        for (Object cellContentElement : cellCoordinates.getCell().getContent()) {
            if (XmlUtils.unwrap(cellContentElement) instanceof P) {
                P p = (P)cellContentElement;
                ParagraphCoordinates paragraphCoordinates = new ParagraphCoordinates(p, elementIndex, cellCoordinates);
                this.onParagraph(paragraphCoordinates);
            } else if (XmlUtils.unwrap(cellContentElement) instanceof Tbl) {
                Tbl nestedTable = (Tbl)((JAXBElement)cellContentElement).getValue();
                TableCoordinates innerTableCoordinates = new TableCoordinates(nestedTable, elementIndex, cellCoordinates);
                this.walkTable(innerTableCoordinates);
            }
            ++elementIndex;
        }
    }

    protected abstract void onParagraph(ParagraphCoordinates var1);

    protected abstract void onTable(TableCoordinates var1);

    protected abstract void onTableCell(TableCellCoordinates var1);

    protected abstract void onTableRow(TableRowCoordinates var1);
}

