/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.CommentProcessorRegistry;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.processor.displayif.DisplayIfProcessor;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatProcessor;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.replace.typeresolver.DateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;

public class DocxStamper<T> {
    private PlaceholderReplacer<T> placeholderReplacer;
    private CommentProcessorRegistry commentProcessorRegistry = new CommentProcessorRegistry();
    private TypeResolverRegistry typeResolverRegistry = new TypeResolverRegistry(new FallbackResolver());

    public DocxStamper() {
        this.typeResolverRegistry.registerTypeResolver(Image.class, new ImageResolver());
        this.typeResolverRegistry.registerTypeResolver(Date.class, new DateResolver("dd.MM.yyyy"));
        this.placeholderReplacer = new PlaceholderReplacer(this.typeResolverRegistry);
        this.commentProcessorRegistry.registerCommentProcessor(IRepeatProcessor.class, new RepeatProcessor(this.typeResolverRegistry));
        this.commentProcessorRegistry.registerCommentProcessor(IDisplayIfProcessor.class, new DisplayIfProcessor());
    }

    public void stamp(InputStream template, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            WordprocessingMLPackage document = WordprocessingMLPackage.load((InputStream)template);
            this.stamp(document, contextRoot, out);
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public void stamp(WordprocessingMLPackage document, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            this.replaceExpressions(document, contextRoot);
            this.processComments(document, contextRoot);
            document.save(out);
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    private void replaceExpressions(WordprocessingMLPackage document, T contextRoot) {
        this.placeholderReplacer.resolveExpressions(document, contextRoot);
    }

    private void processComments(WordprocessingMLPackage document, T contextRoot) {
        this.commentProcessorRegistry.runProcessors(document, contextRoot);
    }

    public TypeResolverRegistry getTypeResolverRegistry() {
        return this.typeResolverRegistry;
    }

    public CommentProcessorRegistry getCommentProcessorRegistry() {
        return this.commentProcessorRegistry;
    }
}

