/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.api.commentprocessor;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.proxy.ContextFactory;
import org.wickedsource.docxstamper.util.CommentUtil;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.walk.coordinates.BaseCoordinatesWalker;
import org.wickedsource.docxstamper.walk.coordinates.ParagraphCoordinates;

public class CommentProcessorRegistry {
    private Logger logger = LoggerFactory.getLogger(CommentProcessorRegistry.class);
    private Map<ICommentProcessor, Class<?>> commentProcessorInterfaces = new HashMap();
    private List<ICommentProcessor> commentProcessors = new ArrayList<ICommentProcessor>();
    private ExpressionResolver expressionResolver = new ExpressionResolver();

    public void registerCommentProcessor(Class<?> interfaceClass, ICommentProcessor commentProcessor) {
        this.commentProcessorInterfaces.put(commentProcessor, interfaceClass);
        this.commentProcessors.add(commentProcessor);
    }

    public <T> void runProcessors(WordprocessingMLPackage document, T contextRoot) {
        Map<BigInteger, CommentWrapper> comments = CommentUtil.getComments(document);
        for (ICommentProcessor processor : this.commentProcessors) {
            try {
                Class<?> commentProcessorInterface = this.commentProcessorInterfaces.get(processor);
                ContextFactory<T> contextFactory = new ContextFactory<T>();
                Object contextRootProxy = contextFactory.createProxy(contextRoot, commentProcessorInterface, processor);
                this.runProcessor(document, processor, comments, contextRootProxy);
            }
            catch (Exception e) {
                throw new DocxStamperException(String.format("Could not create a proxy around context root object of class %s", contextRoot.getClass()), e);
            }
        }
    }

    private <T> void runProcessor(final WordprocessingMLPackage document, final ICommentProcessor processor, final Map<BigInteger, CommentWrapper> comments, final T contextRoot) {
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                Comments.Comment comment = null;
                try {
                    processor.setCurrentParagraphCoordinates(paragraphCoordinates);
                    comment = CommentUtil.getCommentFor((ContentAccessor)paragraphCoordinates.getParagraph(), document);
                }
                catch (Docx4JException e) {
                    CommentProcessorRegistry.this.logger.warn(String.format("Skipping comment because comment could not be loaded for paragraph at coordinates: %s", paragraphCoordinates.toString()), (Throwable)e);
                    return;
                }
                if (comment != null) {
                    CommentWrapper commentWrapper = (CommentWrapper)comments.get(comment.getId());
                    String commentString = CommentUtil.getCommentString(comment);
                    try {
                        CommentProcessorRegistry.this.expressionResolver.resolveExpression(commentString, contextRoot);
                        CommentUtil.deleteComment(commentWrapper);
                        CommentProcessorRegistry.this.logger.debug(String.format("Comment '%s' has been successfully processed by comment processor %s.", commentString, processor.getClass()));
                    }
                    catch (SpelEvaluationException | SpelParseException e) {
                        CommentProcessorRegistry.this.logger.warn(String.format("Skipping comment expression '%s' because it can not be resolved by comment processor %s. Reason: %s. Set log level to TRACE to view Stacktrace.", commentString, processor.getClass(), e.getMessage()));
                        CommentProcessorRegistry.this.logger.trace("Reason for skipping comment: ", e);
                    }
                }
            }
        };
        walker.walk();
        processor.commitChanges(document);
    }
}

