/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.replace;

import java.util.List;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParseException;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.el.ExpressionUtil;
import org.wickedsource.docxstamper.replace.ParagraphWrapper;
import org.wickedsource.docxstamper.util.RunUtil;
import org.wickedsource.docxstamper.walk.coordinates.BaseCoordinatesWalker;
import org.wickedsource.docxstamper.walk.coordinates.ParagraphCoordinates;

public class PlaceholderReplacer<T> {
    private Logger logger = LoggerFactory.getLogger(PlaceholderReplacer.class);
    private ExpressionUtil expressionUtil = new ExpressionUtil();
    private ExpressionResolver expressionResolver = new ExpressionResolver();
    private TypeResolverRegistry typeResolverRegistry;

    public PlaceholderReplacer(TypeResolverRegistry typeResolverRegistry) {
        this.typeResolverRegistry = typeResolverRegistry;
    }

    public void resolveExpressions(final WordprocessingMLPackage document, final T expressionContext) {
        BaseCoordinatesWalker walker = new BaseCoordinatesWalker(document){

            @Override
            protected void onParagraph(ParagraphCoordinates paragraphCoordinates) {
                PlaceholderReplacer.this.resolveExpressionsForParagraph(paragraphCoordinates.getParagraph(), expressionContext, document);
            }
        };
        walker.walk();
    }

    public void resolveExpressionsForParagraph(P p, T expressionContext, WordprocessingMLPackage document) {
        ParagraphWrapper paragraphWrapper = new ParagraphWrapper(p);
        List<String> placeholders = this.expressionUtil.findExpressions(paragraphWrapper.getText());
        for (String placeholder : placeholders) {
            try {
                Object replacement = this.expressionResolver.resolveExpression(placeholder, expressionContext);
                if (replacement == null) continue;
                ITypeResolver resolver = this.typeResolverRegistry.getResolverForType(replacement.getClass());
                Object replacementObject = resolver.resolve(document, replacement);
                if (replacementObject instanceof R) {
                    RunUtil.applyParagraphStyle(p, (R)replacementObject);
                }
                paragraphWrapper.replace(placeholder, replacementObject);
                this.logger.debug(String.format("Replaced expression '%s' with value provided by TypeResolver %s", placeholder, resolver.getClass()));
            }
            catch (SpelEvaluationException | SpelParseException e) {
                this.logger.warn(String.format("Expression %s could not be resolved against context root of type %s. Reason: %s. Set log level to TRACE to view Stacktrace.", placeholder, expressionContext.getClass(), e.getMessage()));
                this.logger.trace("Reason for skipping expression:", e);
            }
        }
    }
}

