/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.wml.CommentRangeEnd;
import org.docx4j.wml.CommentRangeStart;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wickedsource.docxstamper.replace.ParagraphWrapper;
import org.wickedsource.docxstamper.util.CommentWrapper;
import org.wickedsource.docxstamper.walk.BaseDocumentWalker;

public class CommentUtil {
    private static Logger logger = LoggerFactory.getLogger(CommentUtil.class);

    private CommentUtil() {
    }

    public static Comments.Comment getCommentFor(ContentAccessor object, WordprocessingMLPackage document) throws Docx4JException {
        for (Object contentObject : object.getContent()) {
            if (!(contentObject instanceof CommentRangeStart)) continue;
            try {
                BigInteger id = ((CommentRangeStart)contentObject).getId();
                CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
                Comments comments = (Comments)commentsPart.getContents();
                for (Comments.Comment comment : comments.getComment()) {
                    if (!comment.getId().equals(id)) continue;
                    return comment;
                }
            }
            catch (InvalidFormatException e) {
                logger.warn(String.format("Error while searching comment. Skipping object %s.", object), (Throwable)e);
            }
        }
        return null;
    }

    public static String getCommentStringFor(ContentAccessor object, WordprocessingMLPackage document) throws Docx4JException {
        Comments.Comment comment = CommentUtil.getCommentFor(object, document);
        return CommentUtil.getCommentString(comment);
    }

    public static String getCommentString(Comments.Comment comment) {
        StringBuilder builder = new StringBuilder();
        for (Object commentChildObject : comment.getContent()) {
            if (!(commentChildObject instanceof P)) continue;
            builder.append(new ParagraphWrapper((P)commentChildObject).getText());
        }
        return builder.toString();
    }

    public static void deleteComment(CommentWrapper comment) {
        if (comment.getCommentRangeEnd() != null) {
            ContentAccessor commentRangeEndParent = (ContentAccessor)comment.getCommentRangeEnd().getParent();
            commentRangeEndParent.getContent().remove(comment.getCommentRangeEnd());
            CommentUtil.deleteCommentReference(commentRangeEndParent, comment.getCommentRangeEnd().getId());
        }
        if (comment.getCommentRangeStart() != null) {
            ContentAccessor commentRangeStartParent = (ContentAccessor)comment.getCommentRangeStart().getParent();
            commentRangeStartParent.getContent().remove(comment.getCommentRangeStart());
            CommentUtil.deleteCommentReference(commentRangeStartParent, comment.getCommentRangeStart().getId());
        }
    }

    private static void deleteCommentReference(ContentAccessor parent, BigInteger commentId) {
        int index = 0;
        Integer indexToDelete = null;
        for (Object contentObject : parent.getContent()) {
            if (contentObject instanceof R) {
                for (Object runContentObject : ((R)contentObject).getContent()) {
                    BigInteger foundCommentId;
                    Object unwrapped = XmlUtils.unwrap(runContentObject);
                    if (!(unwrapped instanceof R.CommentReference) || !(foundCommentId = ((R.CommentReference)unwrapped).getId()).equals(commentId)) continue;
                    indexToDelete = index;
                    break;
                }
            }
            ++index;
        }
        if (indexToDelete != null) {
            parent.getContent().remove(indexToDelete);
        }
    }

    public static Map<BigInteger, CommentWrapper> getComments(WordprocessingMLPackage document) {
        HashMap<BigInteger, CommentWrapper> comments = new HashMap<BigInteger, CommentWrapper>();
        CommentUtil.collectCommentRanges(comments, document);
        CommentUtil.collectComments(comments, document);
        return comments;
    }

    private static void collectCommentRanges(final Map<BigInteger, CommentWrapper> comments, WordprocessingMLPackage document) {
        BaseDocumentWalker documentWalker = new BaseDocumentWalker((ContentAccessor)document.getMainDocumentPart()){

            @Override
            protected void onCommentRangeStart(CommentRangeStart commentRangeStart) {
                CommentWrapper commentWrapper = (CommentWrapper)comments.get(commentRangeStart.getId());
                if (commentWrapper == null) {
                    commentWrapper = new CommentWrapper();
                    comments.put(commentRangeStart.getId(), commentWrapper);
                }
                commentWrapper.setCommentRangeStart(commentRangeStart);
            }

            @Override
            protected void onCommentRangeEnd(CommentRangeEnd commentRangeEnd) {
                CommentWrapper commentWrapper = (CommentWrapper)comments.get(commentRangeEnd.getId());
                if (commentWrapper == null) {
                    commentWrapper = new CommentWrapper();
                    comments.put(commentRangeEnd.getId(), commentWrapper);
                }
                commentWrapper.setCommentRangeEnd(commentRangeEnd);
            }
        };
        documentWalker.walk();
    }

    private static void collectComments(Map<BigInteger, CommentWrapper> comments, WordprocessingMLPackage document) {
        try {
            CommentsPart commentsPart = (CommentsPart)document.getParts().get(new PartName("/word/comments.xml"));
            if (commentsPart != null) {
                for (Comments.Comment comment : ((Comments)commentsPart.getContents()).getComment()) {
                    CommentWrapper commentWrapper = comments.get(comment.getId());
                    if (commentWrapper == null) continue;
                    commentWrapper.setComment(comment);
                }
            }
        }
        catch (Docx4JException e) {
            throw new IllegalStateException(e);
        }
    }
}

