/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.api.typeresolver;

import java.util.HashMap;
import java.util.Map;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;

public class TypeResolverRegistry {
    private ITypeResolver defaultResolver;
    private Map<Class<?>, ITypeResolver> typeResolversByType = new HashMap();

    public TypeResolverRegistry(ITypeResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }

    public <T> void registerTypeResolver(Class<T> resolvedType, ITypeResolver resolver) {
        this.typeResolversByType.put(resolvedType, resolver);
    }

    public <T> ITypeResolver getResolverForType(Class<T> type) {
        ITypeResolver resolver = this.typeResolversByType.get(type);
        if (resolver == null) {
            return this.defaultResolver;
        }
        return resolver;
    }

    public void setDefaultResolver(ITypeResolver defaultResolver) {
        this.defaultResolver = defaultResolver;
    }
}

