/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import java.util.HashMap;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.Tc;
import org.wickedsource.docxstamper.api.coordinates.ParagraphCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableCoordinates;
import org.wickedsource.docxstamper.api.coordinates.TableRowCoordinates;
import org.wickedsource.docxstamper.util.TableCellUtil;

public class ObjectDeleter {
    private WordprocessingMLPackage document;
    private int objectsDeletedFromMainDocument = 0;
    private Map<ContentAccessor, Integer> deletedObjectsPerParent = new HashMap<ContentAccessor, Integer>();

    public ObjectDeleter(WordprocessingMLPackage document) {
        this.document = document;
    }

    public void deleteParagraph(ParagraphCoordinates paragraphCoordinates) {
        if (paragraphCoordinates.getParentTableCellCoordinates() == null) {
            int indexToDelete = paragraphCoordinates.getIndex() - this.objectsDeletedFromMainDocument;
            this.document.getMainDocumentPart().getContent().remove(indexToDelete);
            ++this.objectsDeletedFromMainDocument;
        } else {
            Tc parentCell = paragraphCoordinates.getParentTableCellCoordinates().getCell();
            this.deleteFromCell(parentCell, paragraphCoordinates.getIndex());
        }
    }

    private void deleteFromCell(Tc cell, int index) {
        Integer objectsDeletedFromParent = this.deletedObjectsPerParent.get(cell);
        if (objectsDeletedFromParent == null) {
            objectsDeletedFromParent = 0;
        }
        cell.getContent().remove(index -= objectsDeletedFromParent.intValue());
        if (!TableCellUtil.hasAtLeastOneParagraphOrTable(cell)) {
            TableCellUtil.addEmptyParagraph(cell);
        }
        this.deletedObjectsPerParent.put((ContentAccessor)cell, objectsDeletedFromParent + 1);
    }

    public void deleteTable(TableCoordinates tableCoordinates) {
        if (tableCoordinates.getParentTableCellCoordinates() == null) {
            int indexToDelete = tableCoordinates.getIndex() - this.objectsDeletedFromMainDocument;
            this.document.getMainDocumentPart().getContent().remove(indexToDelete);
            ++this.objectsDeletedFromMainDocument;
        } else {
            Tc parentCell = tableCoordinates.getParentTableCellCoordinates().getCell();
            this.deleteFromCell(parentCell, tableCoordinates.getIndex());
        }
    }

    public void deleteTableRow(TableRowCoordinates tableRowCoordinates) {
        Tbl table = tableRowCoordinates.getParentTableCoordinates().getTable();
        int index = tableRowCoordinates.getIndex();
        Integer objectsDeletedFromTable = this.deletedObjectsPerParent.get(table);
        if (objectsDeletedFromTable == null) {
            objectsDeletedFromTable = 0;
        }
        table.getContent().remove(index -= objectsDeletedFromTable.intValue());
        this.deletedObjectsPerParent.put((ContentAccessor)table, objectsDeletedFromTable + 1);
    }
}

