/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper.util;

import javax.xml.bind.JAXBElement;
import org.docx4j.jaxb.Context;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Text;

public class RunUtil {
    private static ObjectFactory factory = Context.getWmlObjectFactory();

    private RunUtil() {
    }

    public static String getText(R run) {
        String result = "";
        for (Object content : run.getContent()) {
            if (content instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)content;
                if (element.getValue() instanceof Text) {
                    Text textObj = (Text)element.getValue();
                    String text = textObj.getValue();
                    if (!"preserve".equals(textObj.getSpace())) {
                        text = text.trim();
                    }
                    result = result + text;
                    continue;
                }
                if (!(element.getValue() instanceof R.Tab)) continue;
                result = result + "\t";
                continue;
            }
            if (!(content instanceof Text)) continue;
            result = result + ((Text)content).getValue();
        }
        return result;
    }

    public static void applyParagraphStyle(P p, R run) {
        if (p.getPPr() != null && p.getPPr().getRPr() != null) {
            RPr runProperties = new RPr();
            StyleUtil.apply((ParaRPr)p.getPPr().getRPr(), (RPr)runProperties);
            run.setRPr(runProperties);
        }
    }

    public static void setText(R run, String text) {
        run.getContent().clear();
        Text textObj = factory.createText();
        textObj.setSpace("preserve");
        textObj.setValue(text);
        textObj.setSpace("preserve");
        run.getContent().add(textObj);
    }

    public static R create(String text) {
        R run = factory.createR();
        RunUtil.setText(run, text);
        return run;
    }

    public static R create(Object content) {
        R run = factory.createR();
        run.getContent().add(content);
        return run;
    }

    public static R create(String text, P parentParagraph) {
        R run = RunUtil.create(text);
        RunUtil.applyParagraphStyle(parentParagraph, run);
        return run;
    }
}

