/*
 * Decompiled with CFR 0.152.
 */
package org.wickedsource.docxstamper;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.wickedsource.docxstamper.DocxStamperConfiguration;
import org.wickedsource.docxstamper.api.DocxStamperException;
import org.wickedsource.docxstamper.api.commentprocessor.ICommentProcessor;
import org.wickedsource.docxstamper.api.typeresolver.ITypeResolver;
import org.wickedsource.docxstamper.api.typeresolver.TypeResolverRegistry;
import org.wickedsource.docxstamper.el.ExpressionResolver;
import org.wickedsource.docxstamper.processor.CommentProcessorRegistry;
import org.wickedsource.docxstamper.processor.displayif.DisplayIfProcessor;
import org.wickedsource.docxstamper.processor.displayif.IDisplayIfProcessor;
import org.wickedsource.docxstamper.processor.repeat.IRepeatProcessor;
import org.wickedsource.docxstamper.processor.repeat.RepeatProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.IReplaceWithProcessor;
import org.wickedsource.docxstamper.processor.replaceExpression.ReplaceWithProcessor;
import org.wickedsource.docxstamper.proxy.ProxyBuilder;
import org.wickedsource.docxstamper.replace.PlaceholderReplacer;
import org.wickedsource.docxstamper.replace.typeresolver.DateResolver;
import org.wickedsource.docxstamper.replace.typeresolver.FallbackResolver;
import org.wickedsource.docxstamper.replace.typeresolver.image.Image;
import org.wickedsource.docxstamper.replace.typeresolver.image.ImageResolver;

public class DocxStamper<T> {
    private PlaceholderReplacer<T> placeholderReplacer;
    private CommentProcessorRegistry commentProcessorRegistry;
    private TypeResolverRegistry typeResolverRegistry;
    private DocxStamperConfiguration config = new DocxStamperConfiguration();

    public DocxStamper() {
        this.initFields();
    }

    public DocxStamper(DocxStamperConfiguration config) {
        this.config = config;
        this.initFields();
    }

    private void initFields() {
        this.typeResolverRegistry = new TypeResolverRegistry(new FallbackResolver());
        this.typeResolverRegistry.registerTypeResolver(Image.class, new ImageResolver());
        this.typeResolverRegistry.registerTypeResolver(Date.class, new DateResolver("dd.MM.yyyy"));
        for (Map.Entry<Class<?>, ITypeResolver> entry : this.config.getTypeResolvers().entrySet()) {
            this.typeResolverRegistry.registerTypeResolver(entry.getKey(), entry.getValue());
        }
        ExpressionResolver expressionResolver = new ExpressionResolver(this.config.getEvaluationContextConfigurer());
        this.placeholderReplacer = new PlaceholderReplacer(this.typeResolverRegistry, this.config.getLineBreakPlaceholder());
        this.placeholderReplacer.setExpressionResolver(expressionResolver);
        this.commentProcessorRegistry = new CommentProcessorRegistry(this.placeholderReplacer);
        this.commentProcessorRegistry.setExpressionResolver(expressionResolver);
        this.commentProcessorRegistry.setFailOnInvalidExpression(this.config.isFailOnUnresolvedExpression());
        this.commentProcessorRegistry.registerCommentProcessor(IRepeatProcessor.class, new RepeatProcessor(this.typeResolverRegistry));
        this.commentProcessorRegistry.registerCommentProcessor(IDisplayIfProcessor.class, new DisplayIfProcessor());
        this.commentProcessorRegistry.registerCommentProcessor(IReplaceWithProcessor.class, new ReplaceWithProcessor());
        for (Map.Entry<Class<?>, ICommentProcessor> entry : this.config.getCommentProcessors().entrySet()) {
            this.commentProcessorRegistry.registerCommentProcessor(entry.getKey(), entry.getValue());
        }
    }

    public void stamp(InputStream template, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            WordprocessingMLPackage document = WordprocessingMLPackage.load((InputStream)template);
            this.stamp(document, contextRoot, out);
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    public void stamp(WordprocessingMLPackage document, T contextRoot, OutputStream out) throws DocxStamperException {
        try {
            ProxyBuilder<T> proxyBuilder = this.addCustomInterfacesToContextRoot(contextRoot, this.config.getExpressionFunctions());
            this.replaceExpressions(document, proxyBuilder);
            this.processComments(document, proxyBuilder);
            document.save(out);
            this.commentProcessorRegistry.reset();
        }
        catch (DocxStamperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocxStamperException(e);
        }
    }

    private ProxyBuilder<T> addCustomInterfacesToContextRoot(T contextRoot, Map<Class<?>, Object> interfacesToImplementations) {
        ProxyBuilder proxyBuilder = new ProxyBuilder<T>().withRoot(contextRoot);
        if (interfacesToImplementations.isEmpty()) {
            return proxyBuilder;
        }
        for (Map.Entry<Class<?>, Object> entry : interfacesToImplementations.entrySet()) {
            Class<?> interfaceClass = entry.getKey();
            Object implementation = entry.getValue();
            proxyBuilder.withInterface(interfaceClass, implementation);
        }
        return proxyBuilder;
    }

    private void replaceExpressions(WordprocessingMLPackage document, ProxyBuilder<T> proxyBuilder) {
        this.placeholderReplacer.resolveExpressions(document, proxyBuilder);
    }

    private void processComments(WordprocessingMLPackage document, ProxyBuilder<T> proxyBuilder) {
        this.commentProcessorRegistry.runProcessors(document, proxyBuilder);
    }
}

