/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import org.apache.wicket.MetaDataKey;
import org.wicketeer.modelfactory.ModelFactory;
import org.wicketeer.modelfactory.Preconditions;
import org.wicketeer.modelfactory.Reference;
import org.wicketeer.modelfactory.RequestCycleLocal;

class ChainFrom
extends RequestCycleLocal<Object> {
    private static MetaDataKey<Object> key = new Key();

    public ChainFrom() {
        super(key);
    }

    @Override
    public void set(Object value) {
        Reference ref = (Reference)super.get();
        if (ref != null) {
            super.remove();
            throw new IllegalStateException("mutliple from() calls. need to call model(); Original invokation at " + this.render(ref.getInvokationPath()));
        }
        super.set(new Reference(Preconditions.checkNotNull(value)));
    }

    private String render(Exception invokationPath) {
        StackTraceElement[] st;
        StackTraceElement[] stackTraceElementArray = st = invokationPath.getStackTrace();
        int n = st.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
            String cn = stackTraceElement.getClassName();
            if (!cn.contains(ModelFactory.class.getSimpleName()) && !cn.contains(ModelFactory.class.getPackage().getName())) {
                String mn = stackTraceElement.getMethodName();
                int ln = stackTraceElement.getLineNumber();
                String scn = cn.substring(cn.lastIndexOf(46) + 1);
                return String.valueOf(scn) + "." + mn + " (" + scn + ":" + ln + ")";
            }
            ++n2;
        }
        invokationPath.printStackTrace();
        return "";
    }

    @Override
    public Object get() {
        Reference ref = (Reference)super.get();
        if (ref == null) {
            super.remove();
            throw new IllegalStateException("no from() call registered before!");
        }
        return ref.getObject();
    }

    static class Key
    extends MetaDataKey<Object> {
        private static final long serialVersionUID = 1L;

        Key() {
        }
    }
}

