/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import org.apache.wicket.MetaDataKey;
import org.wicketeer.modelfactory.RequestCycleLocal;
import org.wicketeer.modelfactory.internal.Argument;
import org.wicketeer.modelfactory.internal.InvocationSequence;
import org.wicketeer.modelfactory.internal.ProxyArgument;
import org.wicketeer.modelfactory.internal.ProxyUtil;
import org.wicketeer.modelfactory.shaded.org.objenesis.Objenesis;
import org.wicketeer.modelfactory.shaded.org.objenesis.ObjenesisStd;

public final class ArgumentsFactory {
    private static LastArgHolder ARG = new LastArgHolder();
    private static final Objenesis objenesis = new ObjenesisStd(true);

    private ArgumentsFactory() {
    }

    public static <T> T createArgument(Class<T> clazz) {
        return ArgumentsFactory.createArgument(clazz, new InvocationSequence(clazz));
    }

    static <T> T createArgument(Class<T> clazz, InvocationSequence invocationSequence) {
        Object placeholder = ArgumentsFactory.createPlaceholder(clazz, invocationSequence);
        if (ARG.get().getState() == State.ACTIVE) {
            ARG.get().set(placeholder, new Argument(invocationSequence));
        }
        return (T)placeholder;
    }

    private static Object createPlaceholder(Class<?> clazz, InvocationSequence invocationSequence) {
        State stateBeforeCreationCall = ARG.get().getState();
        if (clazz == Void.class || "void".equals(clazz.getName())) {
            if (stateBeforeCreationCall == State.IGNORE) {
                return null;
            }
            throw new IllegalArgumentException("void return type encountered on: " + invocationSequence);
        }
        if (clazz.isPrimitive()) {
            return ArgumentsFactory.createPrimitivePlaceHolder(clazz, invocationSequence);
        }
        if (clazz.isArray()) {
            Class<?> arrayType = clazz.getComponentType();
            return Array.newInstance(arrayType, 0);
        }
        ARG.get().set(State.IGNORE);
        try {
            if (Modifier.isFinal(clazz.getModifiers())) {
                Object object = objenesis.newInstance(clazz);
                return object;
            }
            Object obj = ProxyUtil.createProxy(new ProxyArgument(clazz, invocationSequence), clazz, false, new Class[0]);
            return obj;
        }
        finally {
            ARG.get().set(stateBeforeCreationCall);
        }
    }

    private static Object createPrimitivePlaceHolder(Class<?> clazz, InvocationSequence invocationSequence) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return 1;
        }
        if (clazz == Double.TYPE) {
            return 1.0;
        }
        if (clazz == Long.TYPE) {
            return 1L;
        }
        if (clazz == Short.TYPE) {
            return (short)1;
        }
        if (clazz == Byte.TYPE) {
            return (byte)1;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(1.0f);
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('p');
        }
        throw new IllegalArgumentException("forgotten primitive?");
    }

    public static <T> Argument<T> getAndRemoveArgumentFor(T placeholder) {
        return ARG.get().getAndClear(placeholder);
    }

    public static <T> Argument<T> getArgumentFor(T placeholder) {
        return ARG.get().get(placeholder);
    }

    private static class ArgumentMapping {
        private Argument<?> lastArgument;
        private Object lastPlaceHolder;
        private State state = State.ACTIVE;

        private ArgumentMapping() {
        }

        public State getState() {
            return this.state;
        }

        public void set(Object placeHolder, Argument<?> arg) {
            if (this.state == State.ACTIVE) {
                this.lastArgument = arg;
                this.lastPlaceHolder = placeHolder;
            }
        }

        public void set(State stateToSet) {
            this.state = stateToSet;
        }

        public Argument<?> getAndClear(Object placeHolder) {
            try {
                Argument<?> argument = this.get(placeHolder);
                return argument;
            }
            finally {
                this.set(null, null);
            }
        }

        public Argument<?> get(Object placeHolder) {
            if (placeHolder == null) {
                throw new IllegalStateException("Unknown placeholder " + placeHolder);
            }
            if (placeHolder instanceof Argument) {
                return (Argument)placeHolder;
            }
            if (placeHolder != this.lastPlaceHolder) {
                if (!placeHolder.equals(this.lastPlaceHolder)) {
                    throw new IllegalStateException("Unknown placeholder " + placeHolder);
                }
                return this.lastArgument;
            }
            return this.lastArgument;
        }
    }

    private static class LastArgHolder
    extends RequestCycleLocal<ArgumentMapping> {
        private static final MetaDataKey<ArgumentMapping> LAST_ARG_HOLDER_KEY = new MetaDataKey<ArgumentMapping>(){
            private static final long serialVersionUID = 1L;
        };

        public LastArgHolder() {
            super(LAST_ARG_HOLDER_KEY);
        }

        @Override
        public ArgumentMapping get() {
            ArgumentMapping target = (ArgumentMapping)super.get();
            if (target == null) {
                target = new ArgumentMapping();
                this.set(target);
            }
            return target;
        }
    }

    private static enum State {
        ACTIVE,
        IGNORE;

    }
}

