/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import java.lang.reflect.Method;
import org.wicketeer.modelfactory.internal.ArgumentsFactory;
import org.wicketeer.modelfactory.internal.Invocation;
import org.wicketeer.modelfactory.internal.InvocationInterceptor;
import org.wicketeer.modelfactory.internal.InvocationSequence;

class ProxyArgument
extends InvocationInterceptor {
    private final Class<?> proxiedClass;
    private final InvocationSequence invocationSequence;

    ProxyArgument(Class<?> proxiedClass, InvocationSequence invocationSequence) {
        this.proxiedClass = proxiedClass;
        this.invocationSequence = invocationSequence;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if (name.equals("hashCode")) {
            return this.invocationSequence.hashCode();
        }
        if (name.equals("finalize")) {
            return null;
        }
        if (name.equals("wait")) {
            return null;
        }
        if (name.equals("notify")) {
            return null;
        }
        if (name.equals("notifyAll")) {
            return null;
        }
        if (name.equals("equals")) {
            return this.invocationSequence.equals(args[0]);
        }
        Class<?> returnType = method.getReturnType();
        return ArgumentsFactory.createArgument(returnType, new InvocationSequence(this.invocationSequence, new Invocation(this.proxiedClass, method, args)));
    }
}

