/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.wicketeer.modelfactory.Preconditions;
import org.wicketeer.modelfactory.RequestCycleLocalFrom;
import org.wicketeer.modelfactory.TypedPropertyModel;
import org.wicketeer.modelfactory.internal.Argument;
import org.wicketeer.modelfactory.internal.ArgumentsFactory;
import org.wicketeer.modelfactory.shaded.com.googlecode.gentyref.GenericTypeReflector;

public final class ModelFactory {
    private static RequestCycleLocalFrom localFrom = new RequestCycleLocalFrom();

    private ModelFactory() {
    }

    public static <T> T from(T value) throws NullPointerException {
        Preconditions.checkNotNull(value);
        Class<?> type = value.getClass();
        Object proxy = ModelFactory.fromClass(type);
        localFrom.remove();
        localFrom.set((Object)value);
        return (T)proxy;
    }

    public static <T> T from(IModel<T> model) throws NullPointerException {
        Preconditions.checkNotNull(model);
        Class<?> c = model.getClass();
        Class<?> type = null;
        Type typeParameter = GenericTypeReflector.getTypeParameter(c, IModel.class.getTypeParameters()[0]);
        if (typeParameter instanceof Class) {
            type = (Class<?>)typeParameter;
        }
        if (type == null && IModel.class.isAssignableFrom(c)) {
            try {
                Set<Method> methods = ModelFactory.getAllMethods(c);
                for (Method meth : methods) {
                    if (!"getObject".equals(meth.getName())) continue;
                    type = meth.getReturnType();
                    if (type == Object.class || type == Serializable.class) {
                        type = null;
                        continue;
                    }
                    break;
                }
            }
            catch (SecurityException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        if (type == null && model instanceof IObjectClassAwareModel) {
            type = ((IObjectClassAwareModel)model).getObjectClass();
        }
        if (type == null && c.isAnonymousClass()) {
            type = ModelFactory.tryReflectFromAnonClass(c);
        }
        if (type == null) {
            Object modelObject = model.getObject();
            if (modelObject != null) {
                type = modelObject.getClass();
            } else {
                throw new IllegalArgumentException("Cannot find proper type definition for model given. Please use from(model,Class).");
            }
        }
        return ModelFactory.from(model, type);
    }

    private static Set<Method> getAllMethods(Class<?> type) {
        HashSet<Method> result = new HashSet<Method>();
        result.addAll(ModelFactory.getMethods(type));
        for (Class<?> t : ModelFactory.getAllSuperTypes(type)) {
            result.addAll(ModelFactory.getMethods(t));
        }
        return result;
    }

    private static Set<Class<?>> getAllSuperTypes(Class<?> type) {
        HashSet result = new HashSet();
        if (type != null && !type.equals(Object.class)) {
            result.add(type);
            result.addAll(ModelFactory.getAllSuperTypes(type.getSuperclass()));
            Class<?>[] classArray = type.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                result.addAll(ModelFactory.getAllSuperTypes(ifc));
                ++n2;
            }
        }
        return result;
    }

    private static Set<Method> getMethods(Class<?> t) {
        HashSet<Method> result = new HashSet<Method>();
        result.addAll(Arrays.asList(t.isInterface() ? t.getMethods() : t.getDeclaredMethods()));
        return result;
    }

    private static Class<?> tryReflectFromAnonClass(Class<? extends IModel> c) {
        Type typeParameter;
        TypeVariable<Class<? extends IModel>>[] params = c.getSuperclass().getTypeParameters();
        if (params != null && params.length == 1 && (typeParameter = GenericTypeReflector.getTypeParameter(c, params[0])) instanceof Class) {
            return (Class)typeParameter;
        }
        return null;
    }

    public static <T> IModel<T> model(T path) {
        Object t = localFrom.get();
        if (t == RequestCycleLocalFrom.FROM_CLASS) {
            throw new IllegalStateException("proxy has no staring point, please use path() to get a path expression or use from(IModel)");
        }
        Argument<T> arg = ArgumentsFactory.getArgumentFor(path);
        Class<T> type = arg.getReturnType();
        return new TypedPropertyModel<T>(t, ModelFactory.path(path), type);
    }

    public static String path(Object path) {
        try {
            Argument<Object> a = ArgumentsFactory.getAndRemoveArgumentFor(path);
            String string = a.getInkvokedPropertyName();
            return string;
        }
        finally {
            localFrom.remove();
        }
    }

    public static <T> T fromClass(Class<T> clazz) {
        localFrom.set(RequestCycleLocalFrom.FROM_CLASS);
        return ArgumentsFactory.createArgument(Preconditions.checkNotNull(clazz));
    }

    public static <T> T from(IModel<? extends T> model, Class<T> type) throws NullPointerException {
        Preconditions.checkNotNull(model);
        Preconditions.checkNotNull(type);
        localFrom.set(Preconditions.checkNotNull(model));
        return ArgumentsFactory.createArgument(Preconditions.checkNotNull(type));
    }

    public static boolean hasRootReference() throws IllegalStateException {
        return localFrom.get() != RequestCycleLocalFrom.FROM_CLASS;
    }
}

