/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import org.wicketeer.modelfactory.internal.Invocation;
import org.wicketeer.modelfactory.internal.Invoker;

final class InvocationSequence
implements Invoker {
    private final Class<?> rootInvokedClass;
    private String inkvokedPropertyName;
    Invocation lastInvocation;
    private int hashCode;
    private Invoker invoker = this;

    InvocationSequence(Class<?> rootInvokedClass) {
        this.rootInvokedClass = rootInvokedClass;
    }

    InvocationSequence(InvocationSequence sequence, Invocation invocation) {
        this.rootInvokedClass = sequence.getRootInvokedClass();
        invocation.previousInvocation = sequence.lastInvocation;
        this.lastInvocation = invocation;
    }

    Class<?> getRootInvokedClass() {
        return this.rootInvokedClass;
    }

    String getInkvokedPropertyName() {
        if (this.inkvokedPropertyName == null) {
            this.inkvokedPropertyName = this.calcInkvokedPropertyName();
        }
        return this.inkvokedPropertyName;
    }

    private String calcInkvokedPropertyName() {
        if (this.lastInvocation == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.calcInkvokedPropertyName(this.lastInvocation, this.lastInvocation.previousInvocation, sb);
        return sb.substring(1);
    }

    private void calcInkvokedPropertyName(Invocation inv, Invocation prevInv, StringBuilder sb) {
        if (prevInv != null) {
            this.calcInkvokedPropertyName(prevInv, prevInv.previousInvocation, sb);
        }
        sb.append(".").append(inv.getInvokedPropertyName());
    }

    Class<?> getReturnType() {
        return this.lastInvocation.getReturnType();
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 13 * this.rootInvokedClass.hashCode();
        int factor = 17;
        Invocation invocation = this.lastInvocation;
        while (invocation != null) {
            this.hashCode += factor * invocation.hashCode();
            factor += 2;
            invocation = invocation.previousInvocation;
        }
        return this.hashCode;
    }

    public Object evaluate(Object object) {
        return this.invoker.invokeOn(object);
    }

    @Override
    public Object invokeOn(Object object) {
        return this.invokeOn(this.lastInvocation, object);
    }

    private Object invokeOn(Invocation invocation, Object value) {
        if (invocation == null) {
            return value;
        }
        if (invocation.previousInvocation != null) {
            value = this.invokeOn(invocation.previousInvocation, value);
        }
        return invocation.invokeOn(value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("[");
        if (this.lastInvocation == null) {
            sb.append(this.rootInvokedClass);
        } else {
            this.toString(this.lastInvocation, this.lastInvocation.previousInvocation, sb, true);
        }
        sb.append("]");
        return sb.toString();
    }

    private void toString(Invocation inv, Invocation prevInv, StringBuilder sb, boolean first) {
        if (prevInv != null) {
            this.toString(prevInv, prevInv.previousInvocation, sb, false);
        }
        sb.append(inv);
        if (!first) {
            sb.append(", ");
        }
    }
}

