/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import org.apache.wicket.MetaDataKey;
import org.wicketeer.modelfactory.ModelFactory;
import org.wicketeer.modelfactory.Preconditions;
import org.wicketeer.modelfactory.Reference;
import org.wicketeer.modelfactory.RequestCycleLocal;

class RequestCycleLocalFrom
extends RequestCycleLocal<Object> {
    static final Object FROM_CLASS = new Object();
    private static MetaDataKey<Object> key = new Key();

    public RequestCycleLocalFrom() {
        super(key);
    }

    @Override
    public void set(Object value) {
        Reference ref = (Reference)super.get();
        if (ref != null) {
            super.remove();
            Exception path = ref.getInvokationPath();
            StringBuilder sb = new StringBuilder("mutliple from() calls. You need to call 'model()' or 'path()' first.");
            if (path != null) {
                sb.append(" First (probably missing a 'model()'- or 'path()'-call) invokation of from() at " + this.render(path));
            }
            throw new IllegalStateException(sb.toString());
        }
        super.set(new Reference(Preconditions.checkNotNull(value)));
    }

    private String render(Exception invokationPath) {
        if (invokationPath != null) {
            StackTraceElement[] st;
            for (StackTraceElement stackTraceElement : st = invokationPath.getStackTrace()) {
                String cn = stackTraceElement.getClassName();
                if (cn.contains(ModelFactory.class.getSimpleName()) || cn.contains(ModelFactory.class.getPackage().getName())) continue;
                String mn = stackTraceElement.getMethodName();
                int ln = stackTraceElement.getLineNumber();
                String scn = cn.substring(cn.lastIndexOf(46) + 1);
                return scn + "." + mn + " (" + scn + ":" + ln + ")";
            }
        }
        return "";
    }

    @Override
    public Object get() throws IllegalStateException {
        Reference ref = (Reference)super.get();
        if (ref == null) {
            throw new IllegalStateException("no from() call registered before. Usage: model(from(myObject).myMethod()) would be equivalent to new PropertyModel(myObject,\"myMethod\");");
        }
        return ref.getObject();
    }

    static class Key
    extends MetaDataKey<Object> {
        private static final long serialVersionUID = 1L;

        Key() {
        }
    }
}

