/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.shaded.com.googlecode.gentyref;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.wicketeer.modelfactory.shaded.com.googlecode.gentyref.GenericTypeReflector;

class WildcardTypeImpl
implements WildcardType {
    private final Type[] upperBounds;
    private final Type[] lowerBounds;

    public WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
        if (upperBounds.length == 0) {
            throw new IllegalArgumentException("There must be at least one upper bound. For an unbound wildcard, the upper bound must be Object");
        }
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
    }

    public Type[] getUpperBounds() {
        return (Type[])this.upperBounds.clone();
    }

    public Type[] getLowerBounds() {
        return (Type[])this.lowerBounds.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WildcardType)) {
            return false;
        }
        WildcardType other = (WildcardType)obj;
        return Arrays.equals(this.lowerBounds, other.getLowerBounds()) && Arrays.equals(this.upperBounds, other.getUpperBounds());
    }

    public int hashCode() {
        return Arrays.hashCode(this.lowerBounds) ^ Arrays.hashCode(this.upperBounds);
    }

    public String toString() {
        if (this.lowerBounds.length > 0) {
            return "? super " + GenericTypeReflector.getTypeName(this.lowerBounds[0]);
        }
        if (this.upperBounds[0] == Object.class) {
            return "?";
        }
        return "? extends " + GenericTypeReflector.getTypeName(this.upperBounds[0]);
    }
}

