/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.cycle.RequestCycle;
import org.wicketeer.modelfactory.Preconditions;

public class RequestCycleLocal<T> {
    private final MetaDataKey<T> key;

    public RequestCycleLocal(MetaDataKey<T> key) throws NullPointerException {
        this.key = Preconditions.checkNotNull(key);
    }

    protected final RequestCycle getRequestCycle() throws IllegalStateException {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("Outside of request-cycle");
        }
        return requestCycle;
    }

    public void set(T t) throws NullPointerException {
        this.getRequestCycle().setMetaData(this.key, Preconditions.checkNotNull(t));
    }

    public T get() {
        return (T)this.getRequestCycle().getMetaData(this.key);
    }

    public void remove() {
        this.getRequestCycle().setMetaData(this.key, null);
    }
}

