/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.tester.WicketTester;
import org.wicketeer.modelfactory.ModelFactory;

public class Issue3_RegressionTest
extends TestCase {
    public void testShouldThrowIllegalArg() throws Exception {
        try {
            Model mdl = new Model();
            new WicketTester().startComponentInPage((Component)new TestPanel("panel", (IModel)mdl));
            Issue3_RegressionTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindTypeFromAnonClass() throws Exception {
        Model<Foo> mdl = new Model<Foo>(){};
        WicketTester tester = new WicketTester();
        TestPanel panel = new TestPanel("panel", (IModel)mdl);
        TestPanel tp = (TestPanel)tester.startComponentInPage((Component)panel);
        Foo foo = new Foo();
        foo.setBar("baz");
        mdl.setObject((Object)foo);
        tester.assertLabel("panel:label", "baz");
    }

    public void testFindTypeFromLDM() throws Exception {
        final Foo myFoo = new Foo();
        LoadableDetachableModel<Foo> mdl = new LoadableDetachableModel<Foo>(){

            protected Foo load() {
                String bar = myFoo.getBar();
                if (bar == null) {
                    Assert.fail((String)"too early");
                    return null;
                }
                return myFoo;
            }
        };
        WicketTester tester = new WicketTester();
        TestPanel panel = new TestPanel("panel", (IModel)mdl);
        myFoo.setBar("baz");
        TestPanel tp = (TestPanel)tester.startComponentInPage((Component)panel);
        tester.assertLabel("panel:label", "baz");
    }

    public void testFindTypeFromGetObject() throws Exception {
        Foo myFoo = new Foo();
        Model mdl = new Model((Serializable)myFoo);
        WicketTester tester = new WicketTester();
        TestPanel panel = new TestPanel("panel", (IModel)mdl);
        myFoo.setBar("baz");
        TestPanel tp = (TestPanel)tester.startComponentInPage((Component)panel);
        tester.assertLabel("panel:label", "baz");
    }

    public void testFindTypeFromTypedModel() throws Exception {
        MyModel mdl = new MyModel();
        WicketTester tester = new WicketTester();
        TestPanel panel = new TestPanel("panel", (IModel)mdl);
        Foo myFoo = new Foo();
        myFoo.setBar("baz");
        mdl.setObject(myFoo);
        TestPanel tp = (TestPanel)tester.startComponentInPage((Component)panel);
        tester.assertLabel("panel:label", "baz");
    }

    private static class TestPanel
    extends GenericPanel<Foo>
    implements IMarkupResourceStreamProvider {
        private TestPanel(String id, IModel<Foo> model) {
            super(id, model);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new Label("label", ModelFactory.model((Object)((Foo)ModelFactory.from((IModel)this.getModel())).getBar()))});
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)"<wicket:panel><span wicket:id=\"label\"></span></wicket:panel>");
        }
    }

    private static class Foo
    implements Serializable {
        private String bar;

        private Foo() {
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }

    static class MyModel
    extends Model<Foo> {
        MyModel() {
        }

        public Foo getObject() {
            Foo f = (Foo)super.getObject();
            if (f == null) {
                Assert.fail((String)"too early");
                return null;
            }
            return f;
        }
    }
}

