/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.tester.WicketTester;
import org.wicketeer.modelfactory.ModelFactory;

public class ModelFactoryTest
extends TestCase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private A a;
    public IModel<A> nullModel;

    protected void setUp() throws Exception {
        super.setUp();
        new WicketTester();
        this.a = new A();
    }

    public void testSimpleCallChain() throws Exception {
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((Object)this.a)).getB().getV().getStringProperty());
        pm = this.testSer(pm);
        ModelFactoryTest.assertEquals((String)"bar", (String)((String)pm.getObject()));
    }

    public void testDoubleWrap() throws Exception {
        IModel model1 = ModelFactory.model((Object)((A)ModelFactory.from((Object)this.a)).getB());
        B from = (B)ModelFactory.from((IModel)model1);
        String path = from.getV().getStringProperty();
        IModel pm = ModelFactory.model((Object)path);
        pm = this.testSer(pm);
        ModelFactoryTest.assertEquals((String)"bar", (String)((String)pm.getObject()));
        this.testSer(pm);
    }

    public void testPrimitive() throws Exception {
        IModel model1 = ModelFactory.model((Object)((A)ModelFactory.from((Object)this.a)).getB());
        int model2 = ((B)ModelFactory.from((IModel)model1)).getV().getPrimitiveProperty();
        IModel pm = ModelFactory.model((Object)model2);
        pm = this.testSer(pm);
        ModelFactoryTest.assertEquals((Object)5, (Object)pm.getObject());
    }

    public void testBoolean() throws Exception {
        IModel pm = ModelFactory.model((Object)((B)ModelFactory.from((IModel)ModelFactory.model((Object)((A)ModelFactory.from((Object)this.a)).getB()))).getV().isBooleanProperty());
        pm = this.testSer(pm);
        ModelFactoryTest.assertEquals((Object)Boolean.FALSE, (Object)pm.getObject());
    }

    public void testNonPropertyCall() throws Exception {
        B bProxy = ((A)ModelFactory.from((Object)this.a)).getB();
        IModel bModel = ModelFactory.model((Object)bProxy);
        V vProxy = ((B)ModelFactory.from((IModel)bModel)).getV();
        IModel pm = ModelFactory.model((Object)vProxy.nonPropertyCall());
        pm = this.testSer(pm);
        ModelFactoryTest.assertEquals((String)"ok", (String)((String)pm.getObject()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X> IModel<X> testSer(IModel<X> pm) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)baos);
        oos.writeObject(pm);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            IModel iModel = (IModel)ois.readObject();
            return iModel;
        }
        finally {
            ois.close();
        }
    }

    public void testNullCompatible() throws Exception {
        try {
            ModelFactory.model((Object)ModelFactory.from(null));
            ModelFactoryTest.fail((String)"Nullpointer did not happen");
        }
        catch (NullPointerException e) {
        }
        catch (Exception e) {
            ModelFactoryTest.fail((String)("Different Exception to Nullpointer! " + e.getClass().getName()));
        }
    }

    public void testStateCheck() throws Exception {
        ModelFactoryTest.assertEquals((String)"b.v", (String)ModelFactory.path((Object)((CallingSetterWhileCreating)ModelFactory.from((Object)new CallingSetterWhileCreating())).getB().getV()));
    }

    public void testFromClass() throws Exception {
        A a = (A)ModelFactory.fromClass(A.class);
        try {
            ModelFactory.model((Object)a);
            ModelFactoryTest.fail();
        }
        catch (IllegalStateException ignore) {
        }
        catch (Throwable fallthrough) {
            ModelFactoryTest.fail((String)("unexpected " + fallthrough.toString()));
        }
        ModelFactoryTest.assertNotNull((Object)a);
        ModelFactoryTest.assertTrue((boolean)A.class.isAssignableFrom(a.getClass()));
        ModelFactoryTest.assertNotSame(A.class, a.getClass());
    }

    public void testFromClassRoundTrip() throws Exception {
        A a = (A)ModelFactory.fromClass(A.class);
        try {
            ModelFactory.model((Object)a);
            ModelFactoryTest.fail();
        }
        catch (IllegalStateException ignore) {
        }
        catch (Throwable fallthrough) {
            ModelFactoryTest.fail((String)("unexpected " + fallthrough.toString()));
        }
        V v = a.getB().getV();
        String p = ModelFactory.path((Object)v);
        ModelFactoryTest.assertEquals((String)p, (String)"b.v");
    }

    public void testFromClassNPE() throws Exception {
        try {
            A a = (A)ModelFactory.fromClass(null);
        }
        catch (NullPointerException ignore) {
        }
        catch (Throwable fallthrough) {
            ModelFactoryTest.fail((String)("unexpected " + fallthrough.toString()));
        }
    }

    public void testFromTyped() throws Exception {
        V v = new V();
        String stringProperty = "testFromTyped";
        v.setStringProperty(stringProperty);
        Model a = Model.of((Serializable)new A(new B(v)));
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((IModel)a, A.class)).getB().getV().getStringProperty());
        ModelFactoryTest.assertSame((Object)stringProperty, (Object)pm.getObject());
        this.testSer(pm);
    }

    public void testFromLDM() throws Exception {
        LDM1 ldm1 = new LDM1();
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((IModel)ldm1)).getB().getV().getStringProperty());
        this.testSer(pm);
    }

    public void testFromAROM() throws Exception {
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((IModel)new AROM1())).getB().getV().getStringProperty());
        this.testSer(pm);
    }

    public void testFromAnonModelWithNull() throws Exception {
        Model<A> a = new Model<A>(null){
            private static final long serialVersionUID = 1L;
        };
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((IModel)a)).getB());
        this.testSer(pm);
    }

    public void testFailForNullNonAnon() throws Exception {
        Model a = Model.of((Serializable)null);
        try {
            ModelFactory.from((IModel)a);
            ModelFactoryTest.fail((String)"Missing IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTypeWithNull() throws Exception {
        Model a = Model.of((Serializable)null);
        IModel m = ModelFactory.model((Object)((A)ModelFactory.from((IModel)a, A.class)).getB());
        this.testSer(m);
        ModelFactoryTest.assertNull((Object)m.getObject());
        a.setObject((Serializable)new A());
        ModelFactoryTest.assertNotNull((Object)m.getObject());
    }

    public void testFromAnonLDM() throws Exception {
        LoadableDetachableModel<A> a = new LoadableDetachableModel<A>(){
            private static final long serialVersionUID = 1L;

            protected A load() {
                throw new RuntimeException("load was called, but shouldn't be");
            }
        };
        IModel pm = ModelFactory.model((Object)((A)ModelFactory.from((IModel)a)).getB());
        this.testSer(pm);
    }

    static class AROM1
    extends AbstractReadOnlyModel<A> {
        private static final long serialVersionUID = 1L;

        AROM1() {
        }

        public A getObject() {
            throw new RuntimeException("getObject was called, but shouldn't be");
        }
    }

    static class LDM1
    extends LoadableDetachableModel<A> {
        private static final long serialVersionUID = 1L;

        LDM1() {
        }

        protected A load() {
            throw new RuntimeException("load was called, but shouldn't be");
        }
    }

    public static class CallingSetterWhileCreating
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int x = 1;
        B b = new B();

        public CallingSetterWhileCreating() {
            this.setX(2);
            this.getX();
            this.getB().getV();
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public B getB() {
            return this.b;
        }

        public void setB(B b) {
            this.b = b;
        }
    }

    public static class R2 {
        String foo;
    }

    public static class R1 {
        R2 r2;

        public R2 getR2() {
            return null;
        }

        public void setR2(R2 r2) {
            this.r2 = r2;
        }
    }

    static class V
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String stringProperty = "bar";
        private int primitiveProperty = 5;
        private boolean booleanProperty = false;

        V() {
        }

        public String getStringProperty() {
            return this.stringProperty;
        }

        public void setStringProperty(String stringProperty) {
            this.stringProperty = stringProperty;
        }

        public int getPrimitiveProperty() {
            return this.primitiveProperty;
        }

        public void setPrimitiveProperty(int primitiveProperty) {
            this.primitiveProperty = primitiveProperty;
        }

        public boolean isBooleanProperty() {
            return this.booleanProperty;
        }

        public void setBooleanProperty(boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }

        public String nonPropertyCall() {
            return "ok";
        }
    }

    public static class B
    implements Serializable {
        private V v;
        private static final long serialVersionUID = 1L;

        public B(V v) {
            this.v = v;
        }

        public B() {
            this(new V());
        }

        public V getV() {
            return this.v;
        }
    }

    public static class A
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private B b;

        public A() {
            this(new B());
        }

        public A(B b) {
            this.b = b;
        }

        public B getB() {
            return this.b;
        }
    }
}

