/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IObjectClassAwareModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.wicketeer.modelfactory.Preconditions;
import org.wicketeer.modelfactory.RequestCycleLocalFrom;
import org.wicketeer.modelfactory.TypedPropertyModel;
import org.wicketeer.modelfactory.internal.Argument;
import org.wicketeer.modelfactory.internal.ArgumentsFactory;
import org.wicketeer.modelfactory.shaded.com.googlecode.gentyref.GenericTypeReflector;

public final class ModelFactory {
    private static RequestCycleLocalFrom localFrom = new RequestCycleLocalFrom();

    private ModelFactory() {
    }

    public static <T> T from(T value) throws NullPointerException {
        Preconditions.checkNotNull(value);
        Class<?> type = value.getClass();
        Object proxy = ModelFactory.fromClass(type);
        localFrom.remove();
        localFrom.set((Object)value);
        return (T)proxy;
    }

    public static <T> T from(IModel<T> model) throws NullPointerException {
        Method method;
        Preconditions.checkNotNull(model);
        Class<?> c = model.getClass();
        Class<?> type = null;
        if (LoadableDetachableModel.class.isAssignableFrom(c)) {
            try {
                method = c.getDeclaredMethod("load", new Class[0]);
                type = method.getReturnType();
                if (type == Object.class || type == Serializable.class) {
                    type = null;
                }
            }
            catch (Throwable e) {
                throw new WicketRuntimeException(e);
            }
        }
        if (type == null && IModel.class.isAssignableFrom(c)) {
            try {
                method = c.getMethod("getObject", new Class[0]);
                type = method.getReturnType();
                if (type == Object.class || type == Serializable.class) {
                    type = null;
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        if (type == null && model instanceof IObjectClassAwareModel) {
            type = ((IObjectClassAwareModel)model).getObjectClass();
        }
        if (type == null && c.isAnonymousClass()) {
            type = ModelFactory.tryReflectFromAnonClass(c);
        }
        if (type == null) {
            Object modelObject = model.getObject();
            if (modelObject != null) {
                type = modelObject.getClass();
            } else {
                throw new IllegalArgumentException("Cannot find proper type definition for model given. Please use from(model,Class).");
            }
        }
        return ModelFactory.from(model, type);
    }

    private static Class<?> tryReflectFromAnonClass(Class<? extends IModel> c) {
        Type typeParameter;
        TypeVariable<Class<? extends IModel>>[] params = c.getSuperclass().getTypeParameters();
        if (params != null && params.length == 1 && (typeParameter = GenericTypeReflector.getTypeParameter(c, params[0])) instanceof Class) {
            return (Class)typeParameter;
        }
        return null;
    }

    public static <T> IModel<T> model(T path) {
        Object t = localFrom.get();
        if (t == RequestCycleLocalFrom.FROM_CLASS) {
            throw new IllegalStateException("proxy has no staring point, please use path() to get a path expression or use from(IModel)");
        }
        Argument<T> arg = ArgumentsFactory.getArgumentFor(path);
        Class<T> type = arg.getReturnType();
        return new TypedPropertyModel<T>(t, ModelFactory.path(path), type);
    }

    public static String path(Object path) {
        try {
            Argument<Object> a = ArgumentsFactory.getAndRemoveArgumentFor(path);
            String string = a.getInkvokedPropertyName();
            return string;
        }
        finally {
            localFrom.remove();
        }
    }

    public static <T> T fromClass(Class<T> clazz) {
        localFrom.set(RequestCycleLocalFrom.FROM_CLASS);
        return ArgumentsFactory.createArgument(Preconditions.checkNotNull(clazz));
    }

    public static <T> T from(IModel<? extends T> model, Class<T> type) throws NullPointerException {
        Preconditions.checkNotNull(model);
        Preconditions.checkNotNull(type);
        localFrom.set(Preconditions.checkNotNull(model));
        return ArgumentsFactory.createArgument(Preconditions.checkNotNull(type));
    }

    public static boolean hasRootReference() throws IllegalStateException {
        return localFrom.get() != RequestCycleLocalFrom.FROM_CLASS;
    }
}

