/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory;

import java.io.Serializable;
import junit.framework.TestCase;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.tester.WicketTester;
import org.wicketeer.modelfactory.ModelFactory;

public class Issue5_LDM_Type
extends TestCase {
    public void testFindTypeFromAnonLDM() throws Exception {
        final Foo myFoo = new Foo();
        LoadableDetachableModel<Foo> mdl = new LoadableDetachableModel<Foo>(){
            private static final long serialVersionUID = 1L;

            protected Foo load() {
                String bar = myFoo.getBar();
                if (bar == null) {
                    TestCase.fail((String)"too early");
                    return null;
                }
                return myFoo;
            }
        };
        WicketTester tester = new WicketTester();
        TestPanel panel = new TestPanel("panel", (IModel)mdl);
        myFoo.setBar("baz");
        tester.startComponentInPage((Component)panel);
        tester.assertLabel("panel:label", "baz");
    }

    public void testFindTypeFromHierarchyLDM() throws Exception {
        ComplexLDM mdl = new ComplexLDM();
        WicketTester tester = new WicketTester();
        IModel model = ModelFactory.model((Object)((Foo)ModelFactory.from((IModel)mdl)).getBar());
        Label panel = new Label("label", model);
        tester.startComponentInPage((Component)panel);
        tester.assertLabel("label", "pc");
    }

    static class ParameterizedClass<X, Y>
    extends LoadableDetachableModel<Foo> {
        private static final long serialVersionUID = 1L;

        ParameterizedClass() {
        }

        protected Foo load() {
            Foo foo = new Foo();
            foo.setBar("pc");
            return foo;
        }
    }

    static class ComplexLDM
    extends ParameterizedClass<Integer, Long> {
        private static final long serialVersionUID = 1L;

        ComplexLDM() {
        }
    }

    private static class TestPanel
    extends GenericPanel<Foo>
    implements IMarkupResourceStreamProvider {
        private static final long serialVersionUID = 1L;

        private TestPanel(String id, IModel<Foo> model) {
            super(id, model);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{new Label("label", ModelFactory.model((Object)((Foo)ModelFactory.from((IModel)this.getModel())).getBar()))});
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)"<wicket:panel><span wicket:id=\"label\"></span></wicket:panel>");
        }
    }

    private static class Foo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String bar;

        private Foo() {
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }
    }
}

