/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Locale;

final class Invocation {
    private final Class<?> invokedClass;
    private final Method invokedMethod;
    private String invokedPropertyName;
    private ParameterReference[] weakArgs;
    private transient int hashCode;
    protected Invocation previousInvocation;

    Invocation(Class<?> invokedClass, Method invokedMethod, Object[] args) {
        this.invokedClass = invokedClass;
        this.invokedMethod = invokedMethod;
        invokedMethod.setAccessible(true);
        if (args != null && args.length > 0) {
            this.weakArgs = new ParameterReference[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.weakArgs[i] = invokedMethod.getParameterTypes()[i].isPrimitive() ? new StrongParameterReference(args[i]) : new WeakParameterReference(args[i]);
            }
        }
    }

    protected boolean hasArguments() {
        return this.weakArgs != null;
    }

    private Object[] getConcreteArgs() {
        if (this.weakArgs == null) {
            return new Object[0];
        }
        Object[] args = new Object[this.weakArgs.length];
        for (int i = 0; i < this.weakArgs.length; ++i) {
            args[i] = this.weakArgs[i].get();
        }
        return args;
    }

    protected Class<?> getInvokedClass() {
        return this.invokedClass;
    }

    protected Method getInvokedMethod() {
        return this.invokedMethod;
    }

    protected Class<?> getReturnType() {
        return this.invokedMethod.getReturnType();
    }

    protected String getInvokedPropertyName() {
        if (this.invokedPropertyName == null) {
            this.invokedPropertyName = Invocation.getPropertyName(this.invokedMethod);
        }
        return this.invokedPropertyName;
    }

    protected Object invokeOn(Object object) {
        try {
            return object == null ? null : this.invokedMethod.invoke(object, this.getConcreteArgs());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        if (this.weakArgs == null) {
            return this.invokedMethod.toString();
        }
        StringBuilder sb = new StringBuilder(this.invokedMethod.toString());
        sb.append(" with args ");
        boolean first = true;
        for (ParameterReference arg : this.weakArgs) {
            sb.append(first ? "" : ", ").append(arg.get());
            first = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = 13 * this.invokedClass.hashCode() + 17 * this.invokedMethod.hashCode();
        if (this.weakArgs != null) {
            this.hashCode += 19 * this.weakArgs.length;
        }
        if (this.previousInvocation != null) {
            this.hashCode += 23 * this.previousInvocation.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Invocation otherInvocation = (Invocation)object;
        return Invocation.areNullSafeEquals(this.invokedClass, otherInvocation.getInvokedClass()) && Invocation.areNullSafeEquals(this.invokedMethod, otherInvocation.getInvokedMethod()) && Invocation.areNullSafeEquals(this.previousInvocation, otherInvocation.previousInvocation) && Arrays.equals(this.weakArgs, otherInvocation.weakArgs);
    }

    protected static boolean areNullSafeEquals(Object first, Object second) {
        return first == second || first != null && second != null && first.equals(second);
    }

    public static String getPropertyName(Method invokedMethod) {
        String methodName = invokedMethod.getName();
        if ((methodName.startsWith("get") || methodName.startsWith("set")) && methodName.length() > 3) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is") && methodName.length() > 2) {
            methodName = methodName.substring(2);
        }
        return methodName.substring(0, 1).toLowerCase(Locale.getDefault()) + methodName.substring(1);
    }

    private static final class WeakParameterReference
    extends ParameterReference {
        private final WeakReference<Object> weakRef;

        private WeakParameterReference(Object referent) {
            this.weakRef = new WeakReference<Object>(referent);
        }

        @Override
        protected Object get() {
            return this.weakRef.get();
        }
    }

    private static final class StrongParameterReference
    extends ParameterReference {
        private final Object strongRef;

        private StrongParameterReference(Object referent) {
            this.strongRef = referent;
        }

        @Override
        protected Object get() {
            return this.strongRef;
        }
    }

    private static abstract class ParameterReference {
        private ParameterReference() {
        }

        protected abstract Object get();

        public final boolean equals(Object obj) {
            return obj instanceof ParameterReference && Invocation.areNullSafeEquals(this.get(), ((ParameterReference)obj).get());
        }
    }
}

