/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import java.lang.reflect.Method;
import org.wicketeer.modelfactory.internal.ArgumentsFactory;
import org.wicketeer.modelfactory.internal.Invocation;
import org.wicketeer.modelfactory.internal.InvocationInterceptor;
import org.wicketeer.modelfactory.internal.InvocationSequence;

class ProxyArgument
extends InvocationInterceptor {
    private final Class<?> proxiedClass;
    private final InvocationSequence invocationSequence;

    ProxyArgument(Class<?> proxiedClass, InvocationSequence invocationSequence) {
        this.proxiedClass = proxiedClass;
        this.invocationSequence = invocationSequence;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        String name = method.getName();
        if ("hashCode".equals(name)) {
            return this.invocationSequence.hashCode();
        }
        if ("finalize".equals(name)) {
            return null;
        }
        if ("wait".equals(name)) {
            return null;
        }
        if ("notify".equals(name)) {
            return null;
        }
        if ("notifyAll".equals(name)) {
            return null;
        }
        if ("equals".equals(name)) {
            return this.invocationSequence.equals(args[0]);
        }
        Class<?> returnType = method.getReturnType();
        return ArgumentsFactory.createArgument(returnType, new InvocationSequence(this.invocationSequence, new Invocation(this.proxiedClass, method, args)));
    }
}

