/*
 * Decompiled with CFR 0.152.
 */
package org.wicketeer.modelfactory.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collection;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.wicketeer.modelfactory.internal.ClassImposterizer;
import org.wicketeer.modelfactory.internal.InvocationInterceptor;
import org.wicketeer.modelfactory.internal.UnproxableClassException;

public final class ProxyUtil {
    private ProxyUtil() {
    }

    public static boolean isProxable(Class<?> clazz) {
        return !clazz.isPrimitive() && !Modifier.isFinal(clazz.getModifiers()) && !clazz.isAnonymousClass();
    }

    protected static <T> T createProxy(InvocationInterceptor interceptor, Class<T> clazz, boolean failSafe, Class<?> ... implementedInterface) {
        if (clazz.isInterface()) {
            return (T)ProxyUtil.createNativeJavaProxy(clazz.getClassLoader(), interceptor, ProxyUtil.concatClasses(new Class[]{clazz}, implementedInterface));
        }
        try {
            Enhancer e = ProxyUtil.createEnhancer(interceptor, clazz, implementedInterface);
            return (T)e.create();
        }
        catch (IllegalArgumentException iae) {
            if (Proxy.isProxyClass(clazz)) {
                return (T)ProxyUtil.createNativeJavaProxy(clazz.getClassLoader(), interceptor, ProxyUtil.concatClasses(implementedInterface, clazz.getInterfaces()));
            }
            if (ProxyUtil.isProxable(clazz)) {
                return ClassImposterizer.INSTANCE.imposterise((Callback)interceptor, clazz, implementedInterface);
            }
            return ProxyUtil.manageUnproxableClass(clazz, failSafe);
        }
    }

    public static String enumerate(Collection<?> l, String delimiter) {
        StringBuffer sb = new StringBuffer(128);
        boolean first = true;
        for (Object object : l) {
            if (!first) {
                sb.append(delimiter);
            } else {
                first = false;
            }
            sb.append(object);
        }
        return sb.toString();
    }

    private static <T> T manageUnproxableClass(Class<T> clazz, boolean failSafe) {
        if (failSafe) {
            return null;
        }
        throw new UnproxableClassException(clazz);
    }

    private static Enhancer createEnhancer(MethodInterceptor interceptor, Class<?> clazz, Class<?> ... interfaces) {
        Enhancer enhancer = new Enhancer();
        enhancer.setCallback((Callback)interceptor);
        enhancer.setSuperclass(clazz);
        if (interfaces != null && interfaces.length > 0) {
            enhancer.setInterfaces((Class[])interfaces);
        }
        return enhancer;
    }

    private static Object createNativeJavaProxy(ClassLoader classLoader, InvocationHandler interceptor, Class<?> ... interfaces) {
        return Proxy.newProxyInstance(classLoader, interfaces, interceptor);
    }

    private static Class<?>[] concatClasses(Class<?>[] first, Class<?>[] second) {
        if (first == null || first.length == 0) {
            return second;
        }
        if (second == null || second.length == 0) {
            return first;
        }
        Class[] concatClasses = new Class[first.length + second.length];
        System.arraycopy(first, 0, concatClasses, 0, first.length);
        System.arraycopy(second, 0, concatClasses, first.length, second.length);
        return concatClasses;
    }
}

