/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.artwork.niftycorners;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HeaderResponse;
import org.wicketstuff.artwork.niftycorners.NiftyOption;

public class NiftyCornersBehavior
extends AbstractBehavior {
    protected String tagName = "";
    protected List<NiftyOption> niftyOptions = null;
    protected String decendantsOfSelector = null;
    protected boolean grabTag = false;
    protected boolean singleComponent;
    private Component component;

    public NiftyCornersBehavior() {
        this(NiftyOption.normal);
    }

    public NiftyCornersBehavior(String decendentsOfSelector, boolean grabTag, boolean singleComponent, NiftyOption ... niftyOptions) {
        this.niftyOptions = Arrays.asList(niftyOptions);
        this.decendantsOfSelector = decendentsOfSelector;
        this.grabTag = grabTag;
        this.singleComponent = singleComponent;
    }

    public NiftyCornersBehavior(NiftyOption ... niftyOptions) {
        this(null, true, true, niftyOptions);
    }

    public void bind(Component component) {
        super.bind(component);
        this.component = component;
        component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(this.getNiftyCornersJSReference());
        response.renderCSSReference(this.getNiftyCornersCSSReference());
        if (!this.grabTag && !this.singleComponent) {
            if (this.decendantsOfSelector != null) {
                response.renderOnLoadJavascript(this.getNiftyJS("", this.decendantsOfSelector, false, false));
            } else {
                response.renderOnLoadJavascript(this.getNiftyJS("", this.decendantsOfSelector, true, false));
            }
        }
    }

    private String getNiftyJS(String selectorString) {
        return this.getNiftyJS(selectorString, "", true, true);
    }

    private String getNiftyJS(String selectorString, String descendents, boolean shouldSeperate, boolean grabComponentTag) {
        String niftyOptionsString = "";
        for (NiftyOption niftyOption : this.niftyOptions) {
            if (niftyOptionsString.length() > 0) {
                niftyOptionsString = niftyOptionsString + " ";
            }
            niftyOptionsString = niftyOptionsString + niftyOption.toString();
        }
        String returnString = "Nifty(\"" + selectorString;
        if (shouldSeperate) {
            returnString = returnString + "#";
        }
        returnString = grabComponentTag ? returnString + this.component.getMarkupId() + descendents + "\",\"" + niftyOptionsString + "\")" : returnString + descendents + "\",\"" + niftyOptionsString + "\")";
        return returnString;
    }

    private ResourceReference getNiftyCornersJSReference() {
        return new ResourceReference(NiftyCornersBehavior.class, "niftycube.js");
    }

    private ResourceReference getNiftyCornersCSSReference() {
        return new ResourceReference(NiftyCornersBehavior.class, "niftyCorners.css");
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        this.tagName = tag.getName();
    }

    public void onRendered(final Component component) {
        super.onRendered(component);
        if (this.grabTag) {
            HeaderResponse headerResponse = new HeaderResponse(){

                protected Response getRealResponse() {
                    return component.getResponse();
                }
            };
            if (this.decendantsOfSelector == null) {
                headerResponse.renderOnLoadJavascript(this.getNiftyJS(this.tagName));
            } else {
                headerResponse.renderOnLoadJavascript(this.getNiftyJS(this.tagName, this.decendantsOfSelector, true, true));
            }
        }
    }
}

