/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.artwork.liquidcanvas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.wicketstuff.artwork.liquidcanvas.graphics.Graphics;
import org.wicketstuff.jslibraries.JSReference;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.VersionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiquidCanvasBehavior
extends AbstractBehavior
implements IHeaderContributor {
    private List<Graphics> graphicsList;
    private Component component;

    public LiquidCanvasBehavior(Graphics ... graphics) {
        this.graphicsList = new ArrayList<Graphics>(Arrays.asList(graphics));
    }

    public void bind(Component component) {
        super.bind(component);
        this.component = component;
        component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(this.getJQueryReference());
        response.renderJavascriptReference(this.getLiquidCanvasReference());
        response.renderJavascriptReference(this.getLiquidCanvasPluginsReference());
        response.renderString((CharSequence)this.getExcanvasReference());
        response.renderOnLoadJavascript(this.getCanvasJS());
    }

    private String getCanvasJS() {
        String js = "$(\"#" + this.component.getMarkupId() + "\").liquidCanvas(\"";
        String endJs = "\")";
        boolean first = true;
        for (Graphics g : this.graphicsList) {
            if (!first) {
                js = js + " => ";
            }
            js = this.fillChained(js, g);
            first = false;
        }
        js = js + endJs;
        return js;
    }

    private String fillChained(String js, Graphics g) {
        if (g.isChained()) {
            js = js + "[ ";
        }
        js = js + " " + g.getStringForJS();
        if (g.isChained()) {
            boolean moreChainedGraphics = true;
            Graphics inspect = g.getChainedGraphics();
            while (moreChainedGraphics) {
                moreChainedGraphics = inspect.isChained();
                js = js + " " + inspect.getStringForJS();
                inspect = inspect.getChainedGraphics();
            }
            js = js + " ]";
        }
        return js;
    }

    private String getExcanvasReference() {
        String excanvasUrl = "";
        excanvasUrl = "<!--[if IE]><script type=\"text/javascript\" src=\"" + ((Object)this.component.urlFor(new ResourceReference(LiquidCanvasBehavior.class, "excanvas.js"))).toString() + "\"></script><![endif]-->";
        return excanvasUrl;
    }

    private ResourceReference getLiquidCanvasPluginsReference() {
        return new ResourceReference(LiquidCanvasBehavior.class, "liquid-canvas-plugins.js");
    }

    private ResourceReference getLiquidCanvasReference() {
        return new ResourceReference(LiquidCanvasBehavior.class, "liquid-canvas.js");
    }

    private ResourceReference getJQueryReference() {
        return JSReference.getReference((VersionDescriptor)VersionDescriptor.exactVersion((Library)Library.JQUERY, (int[])new int[]{1, 3, 2}));
    }

    protected List<Graphics> getGraphicsList() {
        return this.graphicsList;
    }
}

