/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews.logic;

import java.util.Iterator;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateMidnightIterator
implements Iterator<DateMidnight> {
    private DateTime mCurrent;
    private final DateTime mEndDateTime;

    public DateMidnightIterator(DateTime start, DateTime end, int first, int count) {
        this.mCurrent = start.plusDays(first);
        this.mEndDateTime = this.mCurrent.plusDays(count);
    }

    public DateMidnightIterator(DateTime start, DateTime end) {
        this(start, end, 0, new Period((ReadableInstant)start, (ReadableInstant)end, PeriodType.days()).getDays() + 1);
    }

    @Override
    public boolean hasNext() {
        return this.mCurrent.isBefore((ReadableInstant)this.mEndDateTime);
    }

    @Override
    public DateMidnight next() {
        DateMidnight dm = new DateMidnight((Object)this.mCurrent);
        this.mCurrent = this.mCurrent.plusDays(1);
        return dm;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("this should not be called");
    }
}

