/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews;

import java.util.Date;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.calendarviews.BaseCalendarView;
import org.wicketstuff.calendarviews.model.IEventProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullWeekCalendarView
extends BaseCalendarView {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullWeekCalendarView.class);
    private static final long serialVersionUID = 1L;

    public FullWeekCalendarView(String id, Date startDate, Date endDate, IEventProvider eventProvider) {
        super(id, startDate, endDate, eventProvider);
    }

    protected final IDataProvider<DateMidnight> createDaysDataProvider() {
        int lastDOW;
        int firstDOW = this.getFirstDayOfWeek();
        int add = firstDOW > (lastDOW = this.getLastDayOfWeek()) ? -7 : 0;
        DateTime start = new DateTime((Object)this.getStartDate()).withDayOfWeek(firstDOW).plusDays(add);
        DateTime end = new DateTime((Object)this.getEndDate()).withDayOfWeek(lastDOW);
        Period period = new Period((ReadableInstant)start, (ReadableInstant)end, PeriodType.days());
        this.getEventProvider().initializeWithDateRange(start.toDate(), end.toDate());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("start: " + start + "; end: " + end + "; days: " + period.getDays());
        }
        return this.createDaysDataProvider(start, end, period);
    }
}

